/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime.wasi;

import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.wasi.DirCaps;
import io.github.kawamuray.wasmtime.wasi.FileCaps;
import java.nio.file.Path;
import java.util.Set;

public class WasiCtx
implements Disposable {
    private long innerPtr;

    public static void addToLinker(Linker linker) {
        WasiCtx.nativeAddToLinker(linker.innerPtr());
    }

    @Override
    public native void dispose();

    private static native void nativeAddToLinker(long var0);

    private static int fileCapBits(Set<FileCaps> caps) {
        return caps.stream().mapToInt(FileCaps::value).reduce(0, (left, right) -> left | right);
    }

    private static int dirCapBits(Set<DirCaps> caps) {
        return caps.stream().mapToInt(DirCaps::value).reduce(0, (left, right) -> left | right);
    }

    public void insertFile(int fd, Path file, Set<FileCaps> caps) {
        this.nativeInsertFile(fd, file.toString(), WasiCtx.fileCapBits(caps));
    }

    private native void nativeInsertFile(int var1, String var2, int var3);

    public void insertDir(int fd, Path dir, Set<DirCaps> dirCaps, Set<FileCaps> fileCaps, Path preopenPath) {
        this.nativeInsertDir(fd, dir.toString(), WasiCtx.dirCapBits(dirCaps), WasiCtx.fileCapBits(fileCaps), preopenPath.toString());
    }

    private native void nativeInsertDir(int var1, String var2, int var3, int var4, String var5);

    public native void pushArg(String var1);

    public native void pushEnv(String var1, String var2);

    public void setStdin(Path path) {
        this.nativeSetStdin(path.toString());
    }

    private native void nativeSetStdin(String var1);

    public void setStdout(Path path) {
        this.nativeSetStdout(path.toString());
    }

    private native void nativeSetStdout(String var1);

    public void setStderr(Path path) {
        this.nativeSetStderr(path.toString());
    }

    private native void nativeSetStderr(String var1);

    public void pushPreopenDir(Path dir, String guestPath) {
        this.nativePushPreopenDir(dir.toString(), guestPath);
    }

    private native void nativePushPreopenDir(String var1, String var2);

    public long takeInnerPtr() {
        long ptr = this.innerPtr;
        this.innerPtr = 0L;
        return ptr;
    }

    public WasiCtx(long innerPtr) {
        this.innerPtr = innerPtr;
    }

    public long innerPtr() {
        return this.innerPtr;
    }
}

