/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime.wasi;

import io.github.kawamuray.wasmtime.NativeLibraryLoader;
import io.github.kawamuray.wasmtime.wasi.WasiCtx;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class WasiCtxBuilder {
    private final List<String[]> envs = new ArrayList<String[]>();
    private final List<String> args = new ArrayList<String>();
    private Path stdinPath;
    private boolean inheritStdin;
    private Path stdoutPath;
    private boolean inheritStdout;
    private Path stderrPath;
    private boolean inheritStderr;
    private final List<PreopenDir> preopenDirs = new ArrayList<PreopenDir>();

    public WasiCtxBuilder env(String var, String value) {
        this.envs.add(new String[]{var, value});
        return this;
    }

    public WasiCtxBuilder inheritEnv() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.env(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public WasiCtxBuilder arg(String arg) {
        this.args.add(arg);
        return this;
    }

    public WasiCtxBuilder args(Collection<String> args) {
        this.args.addAll(args);
        return this;
    }

    public WasiCtxBuilder stdin(Path path) {
        this.stdinPath = path;
        this.inheritStdin = false;
        return this;
    }

    public WasiCtxBuilder stdout(Path path) {
        this.stdoutPath = path;
        this.inheritStdout = false;
        return this;
    }

    public WasiCtxBuilder stderr(Path path) {
        this.stderrPath = path;
        this.inheritStderr = false;
        return this;
    }

    public WasiCtxBuilder inheritStdin() {
        this.stdinPath = null;
        this.inheritStdin = true;
        return this;
    }

    public WasiCtxBuilder inheritStdout() {
        this.stdoutPath = null;
        this.inheritStdout = true;
        return this;
    }

    public WasiCtxBuilder inheritStderr() {
        this.stderrPath = null;
        this.inheritStderr = true;
        return this;
    }

    public WasiCtxBuilder inheritStdio() {
        return this.inheritStdin().inheritStdout().inheritStderr();
    }

    public WasiCtxBuilder preopenedDir(Path dir, String guestPath) {
        this.preopenDirs.add(new PreopenDir(dir.toString(), guestPath));
        return this;
    }

    public WasiCtx build() {
        long wasiCtxPtr = WasiCtxBuilder.nativeBuild(this.envs.toArray(), this.args.toArray(), this.inheritStdin, this.stdinPath == null ? null : this.stdinPath.toString(), this.inheritStdout, this.stdoutPath == null ? null : this.stdoutPath.toString(), this.inheritStderr, this.stderrPath == null ? null : this.stderrPath.toString(), this.preopenDirs.toArray());
        return new WasiCtx(wasiCtxPtr);
    }

    private static native long nativeBuild(Object[] var0, Object[] var1, boolean var2, String var3, boolean var4, String var5, boolean var6, String var7, Object[] var8);

    static {
        NativeLibraryLoader.init();
    }

    public static final class PreopenDir {
        private final String hostPath;
        private final String guestPath;

        public PreopenDir(String hostPath, String guestPath) {
            this.hostPath = hostPath;
            this.guestPath = guestPath;
        }

        public String hostPath() {
            return this.hostPath;
        }

        public String guestPath() {
            return this.guestPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreopenDir)) {
                return false;
            }
            PreopenDir other = (PreopenDir)o;
            String this$hostPath = this.hostPath();
            String other$hostPath = other.hostPath();
            if (this$hostPath == null ? other$hostPath != null : !this$hostPath.equals(other$hostPath)) {
                return false;
            }
            String this$guestPath = this.guestPath();
            String other$guestPath = other.guestPath();
            return !(this$guestPath == null ? other$guestPath != null : !this$guestPath.equals(other$guestPath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostPath = this.hostPath();
            result = result * 59 + ($hostPath == null ? 43 : $hostPath.hashCode());
            String $guestPath = this.guestPath();
            result = result * 59 + ($guestPath == null ? 43 : $guestPath.hashCode());
            return result;
        }

        public String toString() {
            return "WasiCtxBuilder.PreopenDir(hostPath=" + this.hostPath() + ", guestPath=" + this.guestPath() + ")";
        }
    }
}

