/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.spelresolver;

import io.github.resilience4j.spring6.spelresolver.SpelResolver;
import io.github.resilience4j.spring6.spelresolver.SpelRootObject;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class DefaultSpelResolver
implements EmbeddedValueResolverAware,
SpelResolver {
    private static final String PLACEHOLDER_SPEL_REGEX = "^[$#]\\{.+}$";
    private static final String METHOD_SPEL_REGEX = "^#.+$";
    private static final String BEAN_SPEL_REGEX = "^@.+";
    private final SpelExpressionParser expressionParser;
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final BeanFactory beanFactory;
    private StringValueResolver stringValueResolver;

    public DefaultSpelResolver(SpelExpressionParser spelExpressionParser, ParameterNameDiscoverer parameterNameDiscoverer, BeanFactory beanFactory) {
        this.expressionParser = spelExpressionParser;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.beanFactory = beanFactory;
    }

    @Override
    public String resolve(Method method, Object[] arguments, String spelExpression) {
        if (StringUtils.isEmpty((Object)spelExpression)) {
            return spelExpression;
        }
        if (spelExpression.matches(PLACEHOLDER_SPEL_REGEX) && this.stringValueResolver != null) {
            return this.stringValueResolver.resolveStringValue(spelExpression);
        }
        if (spelExpression.matches(METHOD_SPEL_REGEX)) {
            SpelRootObject rootObject = new SpelRootObject(method, arguments);
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)rootObject, method, arguments, this.parameterNameDiscoverer);
            Object evaluated = this.expressionParser.parseExpression(spelExpression).getValue((EvaluationContext)evaluationContext);
            return (String)evaluated;
        }
        if (spelExpression.matches(BEAN_SPEL_REGEX)) {
            SpelRootObject rootObject = new SpelRootObject(method, arguments);
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)rootObject, method, arguments, this.parameterNameDiscoverer);
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
            Object evaluated = this.expressionParser.parseExpression(spelExpression).getValue((EvaluationContext)evaluationContext);
            return (String)evaluated;
        }
        return spelExpression;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }
}

