/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtil {
    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    public static Map<String, String> getFinalFieldValue(Class<?> clazz) throws IllegalAccessException {
        String className = clazz.getName();
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> constants = new HashMap<String, String>();
        for (Field field : fields) {
            if (Modifier.isPrivate(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            constants.put(className + "." + name, String.valueOf(field.get(null)));
        }
        return constants;
    }
}

