/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl;

import io.github.spannm.jackcess.IndexCursor;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.impl.ColumnImpl;
import io.github.spannm.jackcess.impl.CursorImpl;
import io.github.spannm.jackcess.impl.IndexData;
import io.github.spannm.jackcess.impl.IndexImpl;
import io.github.spannm.jackcess.impl.RowIdImpl;
import io.github.spannm.jackcess.impl.RowImpl;
import io.github.spannm.jackcess.impl.TableImpl;
import io.github.spannm.jackcess.util.CaseInsensitiveColumnMatcher;
import io.github.spannm.jackcess.util.ColumnMatcher;
import io.github.spannm.jackcess.util.EntryIterableBuilder;
import io.github.spannm.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IndexCursorImpl
extends CursorImpl
implements IndexCursor {
    private static final System.Logger LOGGER = System.getLogger(IndexCursorImpl.class.getName());
    private final IndexDirHandler mforwardDirHandler = new ForwardIndexDirHandler();
    private final IndexDirHandler mreverseDirHandler = new ReverseIndexDirHandler();
    private final IndexImpl mindex;
    private final IndexData.EntryCursor mentryCursor;
    private Set<String> mindexEntryPattern;

    private IndexCursorImpl(TableImpl _table, IndexImpl _index, IndexData.EntryCursor _entryCursor) throws IOException {
        super(new CursorImpl.IdImpl(_table, _index), _table, new IndexPosition(_entryCursor.getFirstEntry()), new IndexPosition(_entryCursor.getLastEntry()));
        this.mindex = _index;
        this.mindex.initialize();
        this.mentryCursor = _entryCursor;
    }

    public static IndexCursorImpl createCursor(TableImpl _table, IndexImpl _index, Object[] _startRow, boolean _startInclusive, Object[] _endRow, boolean _endInclusive) throws IOException {
        if (_table != _index.getTable()) {
            throw new IllegalArgumentException("Given index is not for given table: " + _index + ", " + _table);
        }
        if (_index.getIndexData().getUnsupportedReason() != null) {
            throw new IllegalArgumentException("Given index " + _index + " is not usable for indexed lookups due to " + _index.getIndexData().getUnsupportedReason());
        }
        IndexCursorImpl cursor = new IndexCursorImpl(_table, _index, _index.cursor(_startRow, _startInclusive, _endRow, _endInclusive));
        cursor.setColumnMatcher(null);
        return cursor;
    }

    private Set<String> getIndexEntryPattern() {
        if (this.mindexEntryPattern == null) {
            this.mindexEntryPattern = new HashSet<String>();
            for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
                this.mindexEntryPattern.add(col.getName());
            }
        }
        return this.mindexEntryPattern;
    }

    @Override
    public IndexImpl getIndex() {
        return this.mindex;
    }

    @Override
    public Row findRowByEntry(Object ... entryValues) throws IOException {
        if (this.findFirstRowByEntry(entryValues)) {
            return this.getCurrentRow();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findFirstRowByEntry(Object ... entryValues) throws IOException {
        CursorImpl.PositionImpl curPos = this.mcurPos;
        CursorImpl.PositionImpl prevPos = this.mprevPos;
        boolean found = false;
        try {
            boolean bl = found = this.findFirstRowByEntryImpl(this.toRowValues(entryValues), true, this.mcolumnMatcher);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException _ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed to restore position", (Throwable)_ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findClosestRowByEntry(Object ... entryValues) throws IOException {
        CursorImpl.PositionImpl curPos = this.mcurPos;
        CursorImpl.PositionImpl prevPos = this.mprevPos;
        boolean found = false;
        try {
            this.findFirstRowByEntryImpl(this.toRowValues(entryValues), false, this.mcolumnMatcher);
            found = true;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException _ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed to restore position", (Throwable)_ex);
                }
            }
        }
    }

    @Override
    public boolean currentRowMatchesEntry(Object ... entryValues) throws IOException {
        return this.currentRowMatchesEntryImpl(this.toRowValues(entryValues), this.mcolumnMatcher);
    }

    @Override
    public EntryIterableBuilder newEntryIterable(Object ... entryValues) {
        return new EntryIterableBuilder(this, entryValues);
    }

    public Iterator<Row> entryIterator(EntryIterableBuilder iterBuilder) {
        return new EntryIterator(iterBuilder.getColumnNames(), this.toRowValues(iterBuilder.getEntryValues()), iterBuilder.getColumnMatcher());
    }

    @Override
    protected IndexDirHandler getDirHandler(boolean moveForward) {
        return moveForward ? this.mforwardDirHandler : this.mreverseDirHandler;
    }

    @Override
    protected boolean isUpToDate() {
        return super.isUpToDate() && this.mentryCursor.isUpToDate();
    }

    @Override
    protected void reset(boolean moveForward) {
        this.mentryCursor.reset(moveForward);
        super.reset(moveForward);
    }

    @Override
    protected void restorePositionImpl(CursorImpl.PositionImpl curPos, CursorImpl.PositionImpl prevPos) throws IOException {
        if (!(curPos instanceof IndexPosition) || !(prevPos instanceof IndexPosition)) {
            throw new IllegalArgumentException("Restored positions must be index positions");
        }
        this.mentryCursor.restorePosition(((IndexPosition)curPos).getEntry(), ((IndexPosition)prevPos).getEntry());
        super.restorePositionImpl(curPos, prevPos);
    }

    @Override
    protected CursorImpl.PositionImpl getRowPosition(RowIdImpl rowId) throws IOException {
        RowImpl row = this.getTable().getRow(this.getRowState(), rowId, this.getIndexEntryPattern());
        this.mentryCursor.beforeEntry(this.getTable().asRow(row));
        return new IndexPosition(this.mentryCursor.getNextEntry());
    }

    @Override
    protected boolean findAnotherRowImpl(ColumnImpl columnPattern, Object valuePattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        Object[] rowValues = (Object[])searchInfo;
        if (rowValues == null || !this.isAtBeginning(moveForward)) {
            return super.findAnotherRowImpl(columnPattern, valuePattern, moveForward, columnMatcher, rowValues);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        return this.currentRowMatchesImpl(columnPattern, valuePattern, columnMatcher);
    }

    protected boolean findFirstRowByEntryImpl(Object[] rowValues, boolean requireMatch, ColumnMatcher columnMatcher) throws IOException {
        if (!this.findPotentialRow(rowValues, requireMatch)) {
            return false;
        }
        if (!requireMatch) {
            return true;
        }
        return this.currentRowMatchesEntryImpl(rowValues, columnMatcher);
    }

    @Override
    protected boolean findAnotherRowImpl(Map<String, ?> rowPattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        Object[] rowValues = (Object[])searchInfo;
        if (rowValues == null || !this.isAtBeginning(moveForward)) {
            return super.findAnotherRowImpl(rowPattern, moveForward, columnMatcher, rowValues);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        boolean exactColumnMatch = rowPattern.keySet().equals(this.getIndexEntryPattern());
        while (this.currentRowMatchesEntryImpl(rowValues, columnMatcher)) {
            if (exactColumnMatch || this.currentRowMatchesImpl(rowPattern, columnMatcher)) {
                return true;
            }
            if (this.moveToAnotherRow(moveForward)) continue;
        }
        return false;
    }

    private boolean currentRowMatchesEntryImpl(Object[] rowValues, ColumnMatcher columnMatcher) throws IOException {
        Row row = this.getCurrentRow(this.getIndexEntryPattern());
        for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
            Object patValue = rowValues[col.getColumnIndex()];
            if (patValue == IndexData.MIN_VALUE || patValue == IndexData.MAX_VALUE) {
                return true;
            }
            String columnName = col.getName();
            Object rowValue = row.get(columnName);
            if (columnMatcher.matches(this.getTable(), columnName, patValue, rowValue)) continue;
            return false;
        }
        return true;
    }

    private boolean findPotentialRow(Object[] rowValues, boolean requireMatch) throws IOException {
        this.mentryCursor.beforeEntry(rowValues);
        IndexData.Entry startEntry = this.mentryCursor.getNextEntry();
        if (requireMatch && !startEntry.getRowId().isValid()) {
            return false;
        }
        this.restorePosition(new IndexPosition(startEntry));
        return true;
    }

    @Override
    protected Object prepareSearchInfo(ColumnImpl columnPattern, Object valuePattern) {
        return this.mentryCursor.getIndexData().constructPartialIndexRow(IndexData.MIN_VALUE, columnPattern.getName(), valuePattern);
    }

    @Override
    protected Object prepareSearchInfo(Map<String, ?> rowPattern) {
        return this.mentryCursor.getIndexData().constructPartialIndexRow(IndexData.MIN_VALUE, rowPattern);
    }

    @Override
    protected boolean keepSearching(ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        if (searchInfo instanceof Object[]) {
            return this.currentRowMatchesEntryImpl((Object[])searchInfo, columnMatcher);
        }
        return true;
    }

    private Object[] toRowValues(Object[] entryValues) {
        return this.mentryCursor.getIndexData().constructPartialIndexRowFromEntry(IndexData.MIN_VALUE, entryValues);
    }

    @Override
    protected CursorImpl.PositionImpl findAnotherPosition(TableImpl.RowState rowState, CursorImpl.PositionImpl curPos, boolean moveForward) throws IOException {
        IndexDirHandler handler = this.getDirHandler(moveForward);
        IndexPosition endPos = (IndexPosition)handler.getEndPosition();
        IndexData.Entry entry = handler.getAnotherEntry();
        return !entry.equals(endPos.getEntry()) ? new IndexPosition(entry) : endPos;
    }

    @Override
    protected ColumnMatcher getDefaultColumnMatcher() {
        if (this.getIndex().isUnique()) {
            return CaseInsensitiveColumnMatcher.INSTANCE;
        }
        return SimpleColumnMatcher.INSTANCE;
    }

    private static final class IndexPosition
    extends CursorImpl.PositionImpl {
        private final IndexData.Entry _entry;

        private IndexPosition(IndexData.Entry entry) {
            this._entry = entry;
        }

        @Override
        public RowIdImpl getRowId() {
            return this.getEntry().getRowId();
        }

        public IndexData.Entry getEntry() {
            return this._entry;
        }

        @Override
        protected boolean equalsImpl(Object o) {
            return this.getEntry().equals(((IndexPosition)o).getEntry());
        }

        public String toString() {
            return "Entry = " + this.getEntry();
        }
    }

    private final class ForwardIndexDirHandler
    extends IndexDirHandler {
        private ForwardIndexDirHandler() {
        }

        @Override
        public CursorImpl.PositionImpl getBeginningPosition() {
            return IndexCursorImpl.this.getFirstPosition();
        }

        @Override
        public CursorImpl.PositionImpl getEndPosition() {
            return IndexCursorImpl.this.getLastPosition();
        }

        @Override
        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursorImpl.this.mentryCursor.getNextEntry();
        }
    }

    private abstract class IndexDirHandler
    extends CursorImpl.DirHandler {
        private IndexDirHandler() {
        }

        public abstract IndexData.Entry getAnotherEntry() throws IOException;
    }

    private final class ReverseIndexDirHandler
    extends IndexDirHandler {
        private ReverseIndexDirHandler() {
        }

        @Override
        public CursorImpl.PositionImpl getBeginningPosition() {
            return IndexCursorImpl.this.getLastPosition();
        }

        @Override
        public CursorImpl.PositionImpl getEndPosition() {
            return IndexCursorImpl.this.getFirstPosition();
        }

        @Override
        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursorImpl.this.mentryCursor.getPreviousEntry();
        }
    }

    private final class EntryIterator
    extends CursorImpl.BaseIterator {
        private final Object[] mrowValues;

        private EntryIterator(Collection<String> _columnNames, Object[] _rowValues, ColumnMatcher columnMatcher) {
            super(_columnNames, false, true, columnMatcher);
            this.mrowValues = _rowValues;
            try {
                this._hasNext = IndexCursorImpl.this.findFirstRowByEntryImpl(_rowValues, true, IndexCursorImpl.this.mcolumnMatcher);
                this._validRow = this._hasNext;
            }
            catch (IOException _ex) {
                throw new UncheckedIOException(_ex);
            }
        }

        @Override
        protected boolean findNext() throws IOException {
            return IndexCursorImpl.this.moveToNextRow() && IndexCursorImpl.this.currentRowMatchesEntryImpl(this.mrowValues, this._colMatcher);
        }
    }
}

