/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.Row;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class RowFilter
implements Predicate<Row> {
    public abstract boolean matches(Row var1);

    @Override
    public boolean test(Row row) {
        return this.matches(row);
    }

    public Iterable<Row> apply(Iterable<? extends Row> iterable) {
        return new FilterIterable(iterable);
    }

    public Stream<Row> filter(Iterable<? extends Row> iterable) {
        return StreamSupport.stream(new FilterIterable(iterable).spliterator(), false).filter(this);
    }

    public static RowFilter matchPattern(final Map<String, ?> rowPattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                for (Map.Entry e : rowPattern.entrySet()) {
                    if (Objects.equals(e.getValue(), row.get(e.getKey()))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static RowFilter matchPattern(final Column columnPattern, final Object valuePattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                return Objects.equals(valuePattern, columnPattern.getRowValue(row));
            }
        };
    }

    public static RowFilter invert(final RowFilter filter) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                return !filter.matches(row);
            }
        };
    }

    public static Iterable<Row> apply(RowFilter rowFilter, Iterable<? extends Row> iterable) {
        return rowFilter != null ? rowFilter.apply(iterable) : iterable;
    }

    private class FilterIterable
    implements Iterable<Row> {
        private final Iterable<? extends Row> _iterable;

        private FilterIterable(Iterable<? extends Row> iterable) {
            this._iterable = iterable;
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                private final Iterator<? extends Row> _iter;
                private Row _next;
                {
                    this._iter = FilterIterable.this._iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this._iter.hasNext()) {
                        this._next = this._iter.next();
                        if (!RowFilter.this.matches(this._next)) continue;
                        return true;
                    }
                    this._next = null;
                    return false;
                }

                @Override
                public Row next() {
                    if (this._next == null) {
                        throw new NoSuchElementException();
                    }
                    return this._next;
                }
            };
        }
    }
}

