/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.sql.SQLException;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.util.Try;

public class AlterRenameCommand
implements ICommand {
    private final String execId;
    private final String oldTableName;
    private final String newTableName;

    public AlterRenameCommand(String _oldTableName, String _newTableName, String _execId) {
        this.oldTableName = _oldTableName;
        this.newTableName = _newTableName;
        this.execId = _execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.oldTableName;
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.DDL;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        Try.catching(() -> new Persist2Jet().renameTable(this.oldTableName, this.newTableName)).orThrow(UcanaccessSQLException::new);
        return null;
    }

    @Override
    public IFeedbackAction rollback() {
        return null;
    }
}

