/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import io.github.spannm.jackcess.DataType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.converters.FormatCache;
import net.ucanaccess.converters.RegionalSettings;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.exception.InvalidFunctionParameterException;
import net.ucanaccess.exception.InvalidIntervalValueException;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.ext.FunctionType;
import net.ucanaccess.util.Try;

public final class Functions {
    private static final System.Logger LOGGER = System.getLogger(Functions.class.getName());
    private static SecureRandom random;
    private static Double rnd;
    private static Double lastRnd;
    private static final double APPROX = 1.0E-8;

    private Functions() {
    }

    static SimpleDateFormat createSimpleDateFormat(String _pt) {
        SimpleDateFormat sdf = new SimpleDateFormat(_pt);
        ((GregorianCalendar)sdf.getCalendar()).setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        return sdf;
    }

    @FunctionType(functionName="Asc", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer asc(String _s) {
        return _s == null || _s.isEmpty() ? null : Integer.valueOf(_s.charAt(0));
    }

    @FunctionType(functionName="Equals", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean equals(Object _obj1, Object _obj2) {
        if (_obj1 == null || _obj2 == null || !_obj1.getClass().equals(_obj2.getClass())) {
            return false;
        }
        if (_obj1.getClass().isArray()) {
            return Arrays.equals((Object[])_obj1, (Object[])_obj2);
        }
        return _obj1.equals(_obj2);
    }

    @FunctionType(functionName="EqualsIgnoreOrder", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean equalsIgnoreOrder(Object _obj1, Object _obj2) {
        if (_obj1 == null || _obj2 == null || !_obj1.getClass().equals(_obj2.getClass())) {
            return false;
        }
        if (_obj1.getClass().isArray()) {
            List<Object> lo2;
            List<Object> lo1 = Arrays.asList((Object[])_obj1);
            return lo1.containsAll(lo2 = Arrays.asList((Object[])_obj2)) && lo2.containsAll(lo1);
        }
        return _obj1.equals(_obj2);
    }

    @FunctionType(functionName="Contains", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean contains(Object _obj1, Object _obj2) {
        if (_obj1 == null || _obj2 == null || !_obj1.getClass().isArray()) {
            return false;
        }
        List<Object> arr1 = Arrays.asList((Object[])_obj1);
        List<Object> arr2 = _obj2.getClass().isArray() ? Arrays.asList((Object[])_obj2) : Arrays.asList(_obj2);
        return arr1.containsAll(arr2);
    }

    @FunctionType(functionName="Atn", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double atn(double _number) {
        return Math.atan(_number);
    }

    @FunctionType(functionName="Sqr", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double sqr(double _number) {
        return Math.sqrt(_number);
    }

    @FunctionType(functionName="CBool", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(BigDecimal _value) {
        return Functions.cboolImpl(_value);
    }

    @FunctionType(functionName="CBool", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(Boolean _value) {
        return Functions.cboolImpl(_value);
    }

    @FunctionType(functionName="CBool", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(String _value) {
        return Functions.cboolImpl(_value);
    }

    private static boolean cboolImpl(Object _obj) {
        if (_obj == null) {
            return false;
        }
        if (_obj instanceof Boolean) {
            return (Boolean)_obj;
        }
        if (_obj instanceof String) {
            return Boolean.parseBoolean((String)_obj);
        }
        return _obj instanceof Number && ((Number)_obj).intValue() != 0;
    }

    @FunctionType(functionName="CCur", argumentTypes={TypesMap.AccessType.CURRENCY}, returnType=TypesMap.AccessType.CURRENCY)
    public static BigDecimal ccur(BigDecimal _value) {
        return _value.setScale(4, RoundingMode.HALF_UP);
    }

    @FunctionType(functionName="CDate", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp cdate(String _dt) {
        return Functions.dateValue(_dt, false);
    }

    @FunctionType(functionName="CDbl", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double cdbl(Double _number) {
        return _number;
    }

    @FunctionType(functionName="CDec", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double cdec(Double _number) {
        return _number;
    }

    @FunctionType(functionName="CInt", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.INTEGER)
    public static Short cint(Double _number) {
        return new BigDecimal((long)Math.floor(_number + 0.499999999999999)).shortValueExact();
    }

    @FunctionType(functionName="CInt", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.INTEGER)
    public static Short cint(boolean _boolean) {
        return (short)(_boolean ? -1 : 0);
    }

    @FunctionType(functionName="CLng", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(Double _value) {
        return (int)Math.floor(_value + 0.5);
    }

    @FunctionType(functionName="CLng", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(String _value) throws UcanaccessSQLException {
        return Try.catching(() -> Functions.clng(FormatCache.getNoArgs().parse(_value).doubleValue())).orThrow(UcanaccessSQLException::new);
    }

    @FunctionType(functionName="CLng", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(Integer _value) {
        return _value;
    }

    @FunctionType(functionName="CLong", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(Double _value) {
        return Functions.clng(_value);
    }

    @FunctionType(functionName="CLong", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(Integer _value) {
        return _value;
    }

    @FunctionType(functionName="CLong", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(boolean _value) {
        return _value ? -1 : 0;
    }

    @FunctionType(functionName="CSign", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.SINGLE)
    public static double csign(double _value) {
        MathContext mc = new MathContext(7);
        return new BigDecimal(Double.toString(_value), mc).doubleValue();
    }

    @FunctionType(functionName="CStr", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(Boolean _value) throws UcanaccessSQLException {
        return Functions.cstrImpl(_value);
    }

    @FunctionType(functionName="CStr", argumentTypes={TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(String _value) {
        return _value;
    }

    @FunctionType(functionName="CStr", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(double _value) throws UcanaccessSQLException {
        return Functions.cstrImpl(_value);
    }

    @FunctionType(functionName="CStr", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(int _value) throws UcanaccessSQLException {
        return Functions.cstrImpl(_value);
    }

    @FunctionType(functionName="CStr", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(Timestamp _value) throws UcanaccessSQLException {
        return _value == null ? null : Functions.format(_value, "general date");
    }

    private static String cstrImpl(Object _value) throws UcanaccessSQLException {
        return _value == null ? null : Functions.format(_value.toString(), "", true);
    }

    @FunctionType(functionName="CVar", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String cvar(Double _value) throws UcanaccessSQLException {
        return Functions.format(_value, "general number");
    }

    @FunctionType(namingConflict=true, functionName="DateAdd", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static java.util.Date dateAdd(String _intv, int _vl, java.util.Date _dt) throws UcanaccessSQLException {
        if (_dt == null || _intv == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(_dt);
        if ("yyyy".equalsIgnoreCase(_intv)) {
            cl.add(1, _vl);
        } else if ("q".equalsIgnoreCase(_intv)) {
            cl.add(2, _vl * 3);
        } else if ("m".equalsIgnoreCase(_intv)) {
            cl.add(2, _vl);
        } else if ("y".equalsIgnoreCase(_intv)) {
            cl.add(6, _vl);
        } else if ("d".equalsIgnoreCase(_intv)) {
            cl.add(6, _vl);
        } else if ("w".equalsIgnoreCase(_intv)) {
            cl.add(7, _vl);
        } else if ("ww".equalsIgnoreCase(_intv)) {
            cl.add(3, _vl);
        } else if ("h".equalsIgnoreCase(_intv)) {
            cl.add(10, _vl);
        } else if ("n".equalsIgnoreCase(_intv)) {
            cl.add(12, _vl);
        } else if ("s".equalsIgnoreCase(_intv)) {
            cl.add(13, _vl);
        } else {
            throw new InvalidIntervalValueException(_intv);
        }
        return _dt instanceof Timestamp ? new Timestamp(cl.getTimeInMillis()) : new Date(cl.getTimeInMillis());
    }

    @FunctionType(namingConflict=true, functionName="DateAdd", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateAdd(String _intv, int _vl, Timestamp _dt) throws UcanaccessSQLException {
        return (Timestamp)Functions.dateAdd(_intv, _vl, (java.util.Date)_dt);
    }

    @FunctionType(namingConflict=true, functionName="DateAdd", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateAdd(String _intv, int _vl, String _dt) throws UcanaccessSQLException {
        return (Timestamp)Functions.dateAdd(_intv, _vl, (java.util.Date)Functions.dateValue(_dt, false));
    }

    @FunctionType(namingConflict=true, functionName="DateDiff", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String _intv, String _dt1, String _dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(_intv, Functions.dateValue(_dt1, false), Functions.dateValue(_dt2, false));
    }

    @FunctionType(namingConflict=true, functionName="DateDiff", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String _intv, String _dt1, Timestamp _dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(_intv, Functions.dateValue(_dt1, false), _dt2);
    }

    @FunctionType(namingConflict=true, functionName="DateDiff", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String _intv, Timestamp _dt1, String _dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(_intv, _dt1, Functions.dateValue(_dt2, false));
    }

    @FunctionType(namingConflict=true, functionName="DateDiff", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String _intv, Timestamp _dt1, Timestamp _dt2) throws UcanaccessSQLException {
        Integer result;
        int sign;
        if (_dt1 == null || _intv == null || _dt2 == null) {
            return null;
        }
        Calendar clMin = Calendar.getInstance();
        Calendar clMax = Calendar.getInstance();
        int n = sign = _dt1.after(_dt2) ? -1 : 1;
        if (sign == 1) {
            clMax.setTime(_dt2);
            clMin.setTime(_dt1);
        } else {
            clMax.setTime(_dt1);
            clMin.setTime(_dt2);
        }
        clMin.set(14, 0);
        clMax.set(14, 0);
        if ("yyyy".equalsIgnoreCase(_intv)) {
            result = clMax.get(1) - clMin.get(1);
        } else if ("q".equalsIgnoreCase(_intv)) {
            result = Functions.dateDiff("yyyy", _dt1, _dt2) * 4 + (clMax.get(2) - clMin.get(2)) / 3;
        } else if ("y".equalsIgnoreCase(_intv) || "d".equalsIgnoreCase(_intv)) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 8.64E7);
        } else if ("m".equalsIgnoreCase(_intv)) {
            result = Functions.dateDiff("yyyy", _dt1, _dt2) * 12 + clMax.get(2) - clMin.get(2);
        } else if ("w".equalsIgnoreCase(_intv) || "ww".equalsIgnoreCase(_intv)) {
            result = (int)Math.floor((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 6.048E8);
        } else if ("h".equalsIgnoreCase(_intv)) {
            result = (int)Math.round((double)(clMax.getTime().getTime() - clMin.getTime().getTime()) / 3600000.0);
        } else if ("n".equalsIgnoreCase(_intv)) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 60000.0);
        } else if ("s".equalsIgnoreCase(_intv)) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 1000.0);
        } else {
            throw new InvalidIntervalValueException(_intv);
        }
        return result * sign;
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _intv, String _dt, Integer _firstDayOfWeek) throws UcanaccessSQLException {
        return Functions.datePart(_intv, Functions.dateValue(_dt, false), _firstDayOfWeek);
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _interval, Timestamp _date, Integer _firstDayOfWeek) throws UcanaccessSQLException {
        Integer ret;
        Integer n = ret = "ww".equalsIgnoreCase(_interval) ? Functions.datePart(_interval, _date, _firstDayOfWeek, (Integer)1) : Functions.datePart(_interval, _date);
        if ("w".equalsIgnoreCase(_interval) && _firstDayOfWeek > 1) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(_date);
            ret = cl.get(7) - _firstDayOfWeek + 1;
            if (ret <= 0) {
                ret = 7 + ret;
            }
        }
        return ret;
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _intv, String _dt, Integer _firstDayOfWeek, Integer _firstWeekOfYear) throws UcanaccessSQLException {
        return Functions.datePart(_intv, Functions.dateValue(_dt, false), _firstDayOfWeek, _firstWeekOfYear);
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _intv, Timestamp _dt, Integer _firstDayOfWeek, Integer _firstWeekOfYear) throws UcanaccessSQLException {
        Integer ret = Functions.datePart(_intv, _dt);
        if (ret != null && "ww".equalsIgnoreCase(_intv) && (_firstWeekOfYear > 1 || _firstDayOfWeek > 1)) {
            Integer n;
            int dow;
            Calendar cl = Calendar.getInstance();
            cl.setTime(_dt);
            cl.set(2, 0);
            cl.set(5, 1);
            Calendar cl1 = Calendar.getInstance();
            cl1.setTime(_dt);
            if (_firstDayOfWeek == 0) {
                _firstDayOfWeek = 1;
            }
            if ((dow = cl.get(7) - _firstDayOfWeek + 1) <= 0) {
                dow = 7 + dow;
                if (cl1.get(7) - _firstDayOfWeek >= 0) {
                    n = ret;
                    ret = ret + 1;
                }
            }
            if (dow > 4 && _firstWeekOfYear == 2) {
                n = ret;
                ret = ret - 1;
            }
            if (dow > 1 && _firstWeekOfYear == 3) {
                n = ret;
                ret = ret - 1;
            }
        }
        return ret;
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _intv, String _dt) throws UcanaccessSQLException {
        return Functions.datePart(_intv, Functions.dateValue(_dt, false));
    }

    @FunctionType(namingConflict=true, functionName="DatePart", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String _intv, Timestamp _dt) throws UcanaccessSQLException {
        if (_intv == null || _dt == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance(Locale.US);
        cl.setTime(_dt);
        if ("yyyy".equalsIgnoreCase(_intv)) {
            return cl.get(1);
        }
        if ("q".equalsIgnoreCase(_intv)) {
            return (int)Math.ceil((double)(cl.get(2) + 1) / 3.0);
        }
        if ("d".equalsIgnoreCase(_intv)) {
            return cl.get(5);
        }
        if ("y".equalsIgnoreCase(_intv)) {
            return cl.get(6);
        }
        if ("m".equalsIgnoreCase(_intv)) {
            return cl.get(2) + 1;
        }
        if ("ww".equalsIgnoreCase(_intv)) {
            return cl.get(3);
        }
        if ("w".equalsIgnoreCase(_intv)) {
            return cl.get(7);
        }
        if ("h".equalsIgnoreCase(_intv)) {
            return cl.get(11);
        }
        if ("n".equalsIgnoreCase(_intv)) {
            return cl.get(12);
        }
        if ("s".equalsIgnoreCase(_intv)) {
            return cl.get(13);
        }
        throw new InvalidIntervalValueException(_intv);
    }

    @FunctionType(functionName="DateSerial", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateSerial(int _year, int _month, int _day) {
        Calendar cl = Calendar.getInstance();
        cl.setLenient(true);
        cl.set(1, _year);
        cl.set(2, _month - 1);
        cl.set(5, _day);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    @FunctionType(functionName="DateValue", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateValue(String _dt) {
        return Functions.dateValue(_dt, true);
    }

    @FunctionType(functionName="Timestamp0", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp timestamp0(String _dt) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        Pattern patDate = Pattern.compile("(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])\\s");
        Pattern patTime = Pattern.compile("([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-5][0-9]|[0-9])");
        Matcher mtc = patDate.matcher(_dt);
        if (mtc.find()) {
            gc.set(Integer.parseInt(mtc.group(1)), Integer.parseInt(mtc.group(2)) - 1, Integer.parseInt(mtc.group(3)));
        } else {
            UcanaccessRuntimeException.throwNow("internal error in parsing timestamp");
        }
        mtc = patTime.matcher(_dt);
        if (mtc.find()) {
            gc.set(11, Integer.parseInt(mtc.group(1)));
            gc.set(12, Integer.parseInt(mtc.group(2)));
            gc.set(13, Integer.parseInt(mtc.group(3)));
        } else {
            UcanaccessRuntimeException.throwNow("internal error in parsing timestamp");
        }
        gc.set(14, 0);
        return new Timestamp(gc.getTime().getTime());
    }

    private static Timestamp dateValue(String _dt, boolean _onlyDate) {
        RegionalSettings reg = RegionalSettings.getRegionalSettings();
        if (!("true".equalsIgnoreCase(reg.getRS()) || "PM".equalsIgnoreCase(reg.getPM()) && "AM".equalsIgnoreCase(reg.getAM()))) {
            _dt = _dt.replaceAll("(?i)" + Pattern.quote(reg.getPM()), "PM").replaceAll("(?i)" + Pattern.quote(reg.getAM()), "AM");
        }
        for (Map.Entry<SimpleDateFormat, Boolean> entry : reg.getDateFormats().entrySet()) {
            SimpleDateFormat sdf = entry.getKey();
            boolean yearOverride = entry.getValue();
            try {
                Timestamp t = new Timestamp(sdf.parse(_dt).getTime());
                if (_onlyDate) {
                    t = Functions.dateValue(t);
                }
                if (yearOverride) {
                    Calendar cl = Calendar.getInstance();
                    int y = cl.get(1);
                    cl.setTime(t);
                    cl.set(1, y);
                    t = new Timestamp(cl.getTime().getTime());
                }
                return t;
            }
            catch (ParseException _ignored) {
                LOGGER.log(System.Logger.Level.DEBUG, "Ignoring {0}", _ignored.toString());
            }
        }
        return null;
    }

    @FunctionType(functionName="DateValue", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateValue(Timestamp _dt) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(_dt);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    @FunctionType(functionName="Format", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(Double _d, String _par) throws UcanaccessSQLException {
        if (_d == null) {
            return "";
        }
        if ("percent".equalsIgnoreCase(_par)) {
            return FormatCache.getZpzz().format(_d * 100.0) + "%";
        }
        if ("fixed".equalsIgnoreCase(_par)) {
            return FormatCache.getZpzz().format(_d);
        }
        if ("standard".equalsIgnoreCase(_par)) {
            return FormatCache.getSharp().format(_d);
        }
        if ("general number".equalsIgnoreCase(_par)) {
            return FormatCache.getNoGrouping().format(_d);
        }
        if ("currency".equalsIgnoreCase(_par)) {
            return FormatCache.getCurrencyDefault().format(_d);
        }
        if ("yes/no".equalsIgnoreCase(_par)) {
            return _d == 0.0 ? "No" : "Yes";
        }
        if ("true/false".equalsIgnoreCase(_par)) {
            return _d == 0.0 ? "False" : "True";
        }
        if ("On/Off".equalsIgnoreCase(_par)) {
            return _d == 0.0 ? "Off" : "On";
        }
        if ("Scientific".equalsIgnoreCase(_par)) {
            return String.format("%6.2E", _d);
        }
        return Try.catching(() -> FormatCache.getDecimalFormat(_par).format(_d)).orThrow(UcanaccessSQLException::new);
    }

    @FunctionType(functionName="Format", argumentTypes={TypesMap.AccessType.TEXT, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(String _s, String _par) throws UcanaccessSQLException {
        if (_s == null) {
            return "";
        }
        return Functions.format(_s, _par, false);
    }

    public static String format(String _s, String _par, boolean _incl) throws UcanaccessSQLException {
        if (Functions.isNumeric(_s)) {
            if (_incl) {
                return Functions.format(Double.parseDouble(_s), _par);
            }
            return Try.catching(() -> Functions.format(FormatCache.getNoArgs().parse(_s).doubleValue(), _par)).orThrow(UcanaccessSQLException::new);
        }
        if (Functions.isDate(_s)) {
            return Functions.format(Functions.dateValue(_s, false), _par);
        }
        return _s;
    }

    private static String formatDate(Timestamp _t, String _pattern) {
        RegionalSettings reg = RegionalSettings.getRegionalSettings();
        SimpleDateFormat sdf = Functions.createSimpleDateFormat(_pattern);
        String ret = sdf.format(_t);
        if (!reg.getRS().equalsIgnoreCase("true")) {
            if (!reg.getAM().equals("AM")) {
                ret = ret.replace("AM", reg.getAM());
            }
            if (!reg.getPM().equals("PM")) {
                ret = ret.replace("PM", reg.getPM());
            }
        } else {
            ret = ret.replace(reg.getPM(), "PM");
            ret = ret.replace(reg.getAM(), "AM");
        }
        return ret;
    }

    @FunctionType(functionName="Format", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(Timestamp _t, String _par) throws UcanaccessSQLException {
        if (_t == null) {
            return "";
        }
        RegionalSettings reg = RegionalSettings.getRegionalSettings();
        if ("long date".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getLongDatePattern());
        }
        if ("medium date".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getMediumDatePattern());
        }
        if ("short date".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getShortDatePattern());
        }
        if ("general date".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getGeneralPattern());
        }
        if ("long time".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getLongTimePattern());
        }
        if ("medium time".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getMediumTimePattern());
        }
        if ("short time".equalsIgnoreCase(_par)) {
            return Functions.formatDate(_t, reg.getShortTimePattern());
        }
        if ("q".equalsIgnoreCase(_par)) {
            return String.valueOf(Functions.datePart(_par, _t));
        }
        return Functions.createSimpleDateFormat(_par.replace('m', 'M').replace('n', 'm').replace("(?i)AM/PM|A/P|AMPM", "a").replace("dddd", "EEEE")).format(_t);
    }

    @FunctionType(functionName="IIf", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String iif(Boolean _b, String _o1, String _o2) {
        return Functions.iifImpl(_b, _o1, _o2);
    }

    @FunctionType(functionName="IIf", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer iif(Boolean _b, Integer _o1, Integer _o2) {
        return Functions.iifImpl(_b, _o1, _o2);
    }

    @FunctionType(functionName="IIf", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double iif(Boolean _b, Double _o1, Double _o2) {
        return Functions.iifImpl(_b, _o1, _o2);
    }

    @FunctionType(functionName="IIf", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.YESNO, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean iif(Boolean _b, Boolean _o1, Boolean _o2) {
        return Functions.iifImpl(_b, _o1, _o2);
    }

    @FunctionType(functionName="IIf", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp iif(Boolean b, Timestamp _o1, Timestamp _o2) {
        return Functions.iifImpl(b, _o1, _o2);
    }

    private static <T> T iifImpl(Boolean _b, T _o1, T _o2) {
        return _b != null && _b != false ? _o1 : _o2;
    }

    @FunctionType(namingConflict=true, functionName="InStr", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(Integer _start, String _text, String _search) {
        return Functions.instr(_start, _text, _search, -1);
    }

    @FunctionType(namingConflict=true, functionName="InStr", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(Integer start, String text, String search, Integer compare) {
        Integer n = start;
        start = start - 1;
        if (compare != 0) {
            text = text.toLowerCase();
        }
        if (text.length() <= start) {
            return 0;
        }
        text = text.substring(start);
        return text.indexOf(search) + start + 1;
    }

    @FunctionType(namingConflict=true, functionName="InStr", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(String text, String search) {
        return Functions.instr(1, text, search, -1);
    }

    @FunctionType(namingConflict=true, functionName="InStr", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(String text, String search, Integer compare) {
        return Functions.instr(1, text, search, compare);
    }

    @FunctionType(functionName="InStrRev", argumentTypes={TypesMap.AccessType.TEXT, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search) {
        return Functions.instrrev(text, search, -1, -1);
    }

    @FunctionType(functionName="InStrRev", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search, Integer start) {
        return Functions.instrrev(text, search, start, -1);
    }

    @FunctionType(functionName="InStrRev", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search, Integer start, Integer compare) {
        if (compare != 0) {
            text = text.toLowerCase();
        }
        if (text.length() <= start) {
            return 0;
        }
        if (start > 0) {
            text = text.substring(0, start);
        }
        return text.lastIndexOf(search) + 1;
    }

    @FunctionType(functionName="IsDate", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isDate(String _value) {
        return Functions.dateValue(_value) != null;
    }

    @FunctionType(functionName="IsDate", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isDate(Timestamp _value) {
        return true;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(String _value) {
        return _value == null;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(Timestamp _value) {
        return _value == null;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(Double _value) {
        return _value == null;
    }

    @FunctionType(functionName="IsNumeric", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNumeric(BigDecimal b) {
        return true;
    }

    @FunctionType(functionName="IsNumeric", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNumeric(String _s) {
        return Try.catching(() -> {
            Currency cr = Currency.getInstance(Locale.getDefault());
            if (_s.startsWith(cr.getSymbol())) {
                return Functions.isNumeric(_s.substring(cr.getSymbol().length()));
            }
            if (_s.startsWith("+") || _s.startsWith("-")) {
                return Functions.isNumeric(_s.substring(1));
            }
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            String sep = "" + dfs.getDecimalSeparator();
            String gs = "" + dfs.getGroupingSeparator();
            if (_s.startsWith(gs)) {
                return false;
            }
            if (_s.startsWith(sep)) {
                return Functions.isNumeric(_s.substring(1));
            }
            String s = ".".equals(sep) ? _s.replaceAll(gs, "") : _s.replace(".", "").replace(sep, ".");
            new BigDecimal(s);
            return true;
        }).orElse(false);
    }

    @FunctionType(functionName="Left", namingConflict=true, argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String left(String _input, int _i) {
        if (_input == null || _i < 0) {
            return null;
        }
        if (_i >= _input.length()) {
            return _input;
        }
        return _input.substring(0, _i);
    }

    @FunctionType(functionName="\"LEFT$\"", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String leftS(String input, int i) {
        return Functions.left(input, i);
    }

    @FunctionType(functionName="Len", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer len(String _value) {
        return _value == null ? null : Integer.valueOf(_value.length());
    }

    @FunctionType(functionName="Mid", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String mid(String _value, int start) {
        return Functions.mid(_value, start, _value.length());
    }

    @FunctionType(functionName="Mid", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String mid(String _value, int start, int length) {
        if (_value == null) {
            return null;
        }
        int len = start - 1 + length;
        if (start < 1) {
            UcanaccessRuntimeException.throwNow("Invalid function call");
        }
        if (len > _value.length()) {
            len = _value.length();
        }
        return _value.substring(start - 1, len);
    }

    @FunctionType(namingConflict=true, functionName="MonthName", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String monthName(int _number) throws UcanaccessSQLException {
        return Functions.monthName(_number, false);
    }

    @FunctionType(namingConflict=true, functionName="MonthName", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.TEXT)
    public static String monthName(int _number, boolean _abbreviate) throws UcanaccessSQLException {
        if (_number >= 1 && _number <= 12) {
            DateFormatSymbols dfs = new DateFormatSymbols();
            return _abbreviate ? dfs.getShortMonths()[_number - 1] : dfs.getMonths()[_number - 1];
        }
        throw new UcanaccessSQLException("Invalid month number");
    }

    @FunctionType(functionName="Date", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp date() {
        return Timestamp.valueOf(LocalDate.now().atStartOfDay());
    }

    @FunctionType(namingConflict=true, functionName="Now", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis() / 1000L * 1000L);
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String nz(String _value) {
        return _value == null ? "" : _value;
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double nz(Double _value) {
        return _value == null ? 0.0 : _value;
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer nz(Integer _value) {
        return _value == null ? 0 : _value;
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.NUMERIC)
    public static BigDecimal nz(BigDecimal _value) {
        return _value == null ? BigDecimal.ZERO : _value;
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String nz(String _value, String _other) {
        return (String)Functions.nz((Object)_value, (Object)_other);
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.NUMERIC, TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.NUMERIC)
    public static BigDecimal nz(BigDecimal value, BigDecimal _other) {
        return (BigDecimal)Functions.nz((Object)value, (Object)_other);
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double nz(Double value, Double _other) {
        return (Double)Functions.nz((Object)value, (Object)_other);
    }

    @FunctionType(functionName="Nz", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer nz(Integer value, Integer _other) {
        return (Integer)Functions.nz((Object)value, (Object)_other);
    }

    private static Object nz(Object value, Object _other) {
        return value == null ? _other : value;
    }

    @FunctionType(functionName="Sgn", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.INTEGER)
    public static short sgn(double _n) {
        return (short)(_n == 0.0 ? 0 : (_n > 0.0 ? 1 : -1));
    }

    @FunctionType(functionName="Sign", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.INTEGER)
    public static short sign(double _n) {
        return Functions.sgn(_n);
    }

    @FunctionType(functionName="Space", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String space(Integer _nr) {
        return " ".repeat(Math.max(0, Objects.requireNonNullElse(_nr, 0)));
    }

    @FunctionType(functionName="Str", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.TEXT)
    public static String str(double d) {
        String pre = d > 0.0 ? " " : "";
        return (double)Math.round(d) == d ? pre + Math.round(d) : pre + d;
    }

    @FunctionType(functionName="Time", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp time() {
        return new Timestamp(LocalDateTime.now().withYear(1899).withMonth(12).withDayOfMonth(30).truncatedTo(ChronoUnit.SECONDS).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    @FunctionType(functionName="Val", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double val(String _val1) {
        return Functions.val((Object)_val1);
    }

    @FunctionType(functionName="Val", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double val(BigDecimal _val1) {
        return Functions.val((Object)_val1);
    }

    private static Double val(Object _val1) {
        if (_val1 == null) {
            return null;
        }
        String val = _val1.toString().trim();
        int lp = val.lastIndexOf(46);
        char[] ca = val.toCharArray();
        StringBuilder sb = new StringBuilder();
        int minLength = 1;
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if ((c == '-' || c == '+') && i == 0) {
                ++minLength;
                sb.append(c);
                continue;
            }
            if (c == ' ') continue;
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c != '.' || i != lp) break;
            sb.append(c);
            if (i != 0 && (i != 1 || minLength != 2)) continue;
            ++minLength;
        }
        if (sb.length() < minLength) {
            return 0.0;
        }
        return Double.parseDouble(sb.toString());
    }

    @FunctionType(functionName="WeekdayName", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String weekdayName(int _number) {
        return Functions.weekdayName(_number, false);
    }

    @FunctionType(functionName="WeekdayName", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.TEXT)
    public static String weekdayName(int _number, boolean _abbreviate) {
        int vbSunday = 1;
        return Functions.weekdayName(_number, _abbreviate, vbSunday);
    }

    @FunctionType(functionName="WeekdayName", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String weekdayName(int _number, boolean _abbreviate, int _firstDayOfWeek) {
        int number;
        int firstDayOfWeek = Math.min(Math.max(1, _firstDayOfWeek), 7);
        int offset = firstDayOfWeek == 1 ? -1 : firstDayOfWeek - 2;
        for (number = _number; number > 7; number -= 7) {
        }
        return DayOfWeek.of(number).plus(offset).getDisplayName(_abbreviate ? TextStyle.SHORT : TextStyle.FULL, Locale.getDefault());
    }

    @FunctionType(functionName="WeekDay", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer weekDay(Timestamp _date) throws UcanaccessSQLException {
        return Functions.datePart("w", _date);
    }

    @FunctionType(functionName="WeekDay", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer weekDay(Timestamp _date, Integer _firstDayOfWeek) throws UcanaccessSQLException {
        return Functions.datePart("w", _date, _firstDayOfWeek);
    }

    @FunctionType(functionName="String", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String string(Integer _nr, String _str) {
        if (_str == null) {
            return null;
        }
        if (_str.isEmpty()) {
            return "";
        }
        return _str.substring(0, 1).repeat(_nr);
    }

    @FunctionType(functionName="TimeSerial", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp timeSerial(Integer _h, Integer _m, Integer _s) {
        return new Timestamp(LocalDateTime.now().withYear(1899).withMonth(12).withDayOfMonth(30).truncatedTo(ChronoUnit.SECONDS).withHour(_h).withMinute(_m).withSecond(_s).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    @FunctionType(functionName="Rnd", argumentTypes={}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double rnd() {
        return Functions.rnd(null);
    }

    @FunctionType(functionName="Rnd", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double rnd(Double _d) {
        if (random == null) {
            random = new SecureRandom();
        }
        if (_d == null || _d > 0.0) {
            lastRnd = random.nextDouble();
            return lastRnd;
        }
        if (_d < 0.0) {
            if (rnd == null) {
                rnd = _d;
            }
            return rnd;
        }
        if (_d == 0.0) {
            if (lastRnd == null) {
                lastRnd = random.nextDouble();
            }
            return lastRnd;
        }
        return null;
    }

    @FunctionType(functionName="StrReverse", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String strReverse(String _value) {
        return _value == null ? null : new StringBuilder(_value).reverse().toString();
    }

    @FunctionType(functionName="StrConv", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String strConv(String _value, int _conversion) {
        if (_value == null) {
            return null;
        }
        if (_conversion == 1) {
            return _value.toUpperCase();
        }
        if (_conversion == 2) {
            return _value.toLowerCase();
        }
        if (_conversion == 3) {
            return _value;
        }
        return _value;
    }

    @FunctionType(functionName="StrComp", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer strComp(String _value1, String _value2, Integer _type) throws UcanaccessSQLException {
        switch (_type) {
            case -1: 
            case 0: 
            case 2: {
                return _value1.compareTo(_value2);
            }
            case 1: {
                return _value1.toUpperCase().compareTo(_value2.toUpperCase());
            }
        }
        throw new InvalidFunctionParameterException("StrComp", (Object)_type);
    }

    @FunctionType(functionName="StrComp", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer strComp(String _value1, String _value2) throws UcanaccessSQLException {
        return Functions.strComp(_value1, _value2, 0);
    }

    @FunctionType(functionName="Int", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer mint(Double _value) {
        return new BigDecimal((long)Math.floor(_value)).intValueExact();
    }

    @FunctionType(functionName="Int", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.INTEGER)
    public static Short mint(boolean _value) {
        return (short)(_value ? -1 : 0);
    }

    @FunctionType(functionName="DDB", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ddb(double cost, double salvage, double life, double period) {
        return Functions.ddb(cost, salvage, life, period, 2.0);
    }

    @FunctionType(functionName="DDB", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ddb(double cost, double salvage, double life, double period, double factor) {
        if (cost < 0.0 || life == 2.0 && period > 1.0) {
            return 0.0;
        }
        if (life < 2.0 || life == 2.0 && period <= 1.0) {
            return cost - salvage;
        }
        if (period <= 1.0) {
            return Math.min(cost * factor / life, cost - salvage);
        }
        double retk = Math.max(salvage - cost * Math.pow((life - factor) / life, period), 0.0);
        return Math.max(factor * cost / life * Math.pow((life - factor) / life, period - 1.0) - retk, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment) {
        return Functions.fv(rate, periods, payment, 0.0, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment, double pv) {
        return Functions.fv(rate, periods, payment, pv, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment, double pv, double type) {
        type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        double fv = pv * Math.pow(1.0 + rate, periods);
        for (int i = 0; i < periods; ++i) {
            fv += payment * Math.pow(1.0 + rate, (double)i + type);
        }
        return -fv;
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv) {
        return Functions.pmt(rate, periods, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv, double fv) {
        return Functions.pmt(rate, periods, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv, double fv, double type) {
        double d = type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        if (rate == 0.0) {
            return -1.0 * (fv + pv) / periods;
        }
        return (fv + pv * Math.pow(1.0 + rate, periods)) * rate / ((type == 1.0 ? 1.0 + rate : 1.0) * (1.0 - Math.pow(1.0 + rate, periods)));
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv) {
        return Functions.nper(rate, pmt, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv, double fv) {
        return Functions.nper(rate, pmt, pv, fv, 0.0);
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        double nper = 0.0;
        if (rate == 0.0) {
            nper = -1.0 * (fv + pv) / pmt;
        } else {
            double cr = (type == 1.0 ? 1.0 + rate : 1.0) * pmt / rate;
            double val1 = cr - fv < 0.0 ? Math.log(fv - cr) : Math.log(cr - fv);
            double val2 = cr - fv < 0.0 ? Math.log(-pv - cr) : Math.log(pv + cr);
            double val3 = Math.log(1.0 + rate);
            nper = (val1 - val2) / val3;
        }
        return nper;
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv) {
        return Functions.ipmt(rate, per, nper, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv, double fv) {
        return Functions.ipmt(rate, per, nper, pv, fv, 0.0);
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        double ipmt = Functions.fv(rate, (int)per - 1, Functions.pmt(rate, nper, pv, fv, type), pv, type) * rate;
        if (type == 1.0) {
            ipmt /= 1.0 + rate;
        }
        return ipmt;
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt) {
        return Functions.pv(rate, nper, pmt, 0.0, 0.0);
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt, double fv) {
        return Functions.pv(rate, nper, pmt, fv, 0.0);
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt, double fv, double type) {
        double d = type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        if (rate == 0.0) {
            return -1.0 * (nper * pmt + fv);
        }
        return ((1.0 - Math.pow(1.0 + rate, nper)) / rate * (type == 1.0 ? 1.0 + rate : 1.0) * pmt - fv) / Math.pow(1.0 + rate, nper);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv) {
        return Functions.ppmt(rate, per, nper, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv, double fv) {
        return Functions.ppmt(rate, per, nper, pv, fv, 0.0);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv, double fv, double type) {
        return Functions.pmt(rate, nper, pv, fv, type) - Functions.ipmt(rate, per, nper, pv, fv, type);
    }

    @FunctionType(functionName="SLN", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double sln(double cost, double salvage, double life) {
        return (cost - salvage) / life;
    }

    @FunctionType(functionName="SYD", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double syd(double cost, double salvage, double life, double per) {
        return (cost - salvage) * (life - per + 1.0) * 2.0 / (life * (life + 1.0));
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv) {
        return Functions.rate(nper, pmt, pv, 0.0, 0.0, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv) {
        return Functions.rate(nper, pmt, pv, fv, 0.0, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv, double type) {
        return Functions.rate(nper, pmt, pv, fv, type, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv, double type, double guess) {
        type = Math.abs(type) >= 1.0 ? 1.0 : 0.0;
        int financialMaxIterations = 20;
        double financialPrecision = 1.0E-7;
        double y = 0.0;
        double y0 = 0.0;
        double y1 = 0.0;
        double x0 = 0.0;
        double f = 0.0;
        double i = 0.0;
        double rate = guess;
        if (Math.abs(rate) < 1.0E-7) {
            y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
        } else {
            f = Math.exp(nper * Math.log(1.0 + rate));
            y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        }
        y0 = pv + pmt * nper + fv;
        y1 = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        x0 = 0.0;
        double x1 = rate;
        for (i = 0.0; Math.abs(y0 - y1) > 1.0E-7 && i < 20.0; i += 1.0) {
            rate = (y1 * x0 - y0 * x1) / (y1 - y0);
            x0 = x1;
            x1 = rate;
            if (Math.abs(rate) < 1.0E-7) {
                y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
            } else {
                f = Math.exp(nper * Math.log(1.0 + rate));
                y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
            }
            y0 = y1;
            y1 = y;
        }
        return rate;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Double res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Boolean res, String datatype) {
        if (res == null) {
            return null;
        }
        return res != false ? -1.0 : 0.0;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(String _res, String _datatype) {
        if (_res == null) {
            return null;
        }
        return Try.catching(() -> {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            String sep = "" + dfs.getDecimalSeparator();
            String gs = "" + dfs.getGroupingSeparator();
            String res = _res.replaceAll(Pattern.quote(gs), "");
            if (!".".equalsIgnoreCase(sep)) {
                res = res.replaceAll(Pattern.quote(sep), ".");
            }
            double d = Functions.val(res);
            DataType dt = DataType.valueOf((String)_datatype);
            if (dt.equals((Object)DataType.BYTE) || dt.equals((Object)DataType.INT) || dt.equals((Object)DataType.LONG)) {
                d = Math.rint(d + 1.0E-8);
            }
            return d;
        }).orIgnore();
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Timestamp res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        return (double)Functions.dateDiff("y", new Timestamp(clbb.getTimeInMillis()), res);
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Boolean res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Double res, String datatype) {
        return res == null ? null : Boolean.valueOf(res != 0.0);
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Timestamp res, String datatype) {
        return null;
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(String res, String datatype) {
        if (res == null) {
            return null;
        }
        if ("-1".equals(res)) {
            return true;
        }
        if ("0".equals(res)) {
            return false;
        }
        return null;
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(String res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Double res, String datatype) {
        if (res == null) {
            return null;
        }
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        DecimalFormat df = new DecimalFormat("#", dfs);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(100);
        return df.format(res);
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Boolean res, String datatype) {
        if (res == null) {
            return null;
        }
        return res != false ? "-1" : "0";
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Timestamp res, String datatype) throws UcanaccessSQLException {
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(res.getTime());
        if (cl.get(10) == 0 && cl.get(12) == 0 && cl.get(13) == 0) {
            return Functions.format(res, "short date");
        }
        return Functions.format(res, "general date");
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Timestamp res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(String res, String datatype) {
        if (res == null) {
            return null;
        }
        return Try.catching(() -> Functions.dateValue(res, false)).orIgnore();
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Boolean res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        clbb.set(14, 0);
        return Functions.dateAdd("y", res != false ? -1 : 0, new Timestamp(clbb.getTimeInMillis()));
    }

    @FunctionType(functionName="orderJet", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String orderJet(String s) {
        return s.replaceAll("([a-zA-Z0-9])[\\-\u2013\u2014]([a-zA-Z0-9])", "$1$2");
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Double res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        clbb.set(14, 0);
        Double d = Math.floor(res);
        Timestamp tr = Functions.dateAdd("y", d.intValue(), new Timestamp(clbb.getTimeInMillis()));
        d = (res - (double)res.intValue()) * 24.0;
        tr = Functions.dateAdd("H", d.intValue(), tr);
        d = (d - (double)d.intValue()) * 60.0;
        tr = Functions.dateAdd("N", d.intValue(), tr);
        d = (d - (double)d.intValue()) * 60.0;
        tr = Functions.dateAdd("S", (int)Math.rint(d + 1.0E-8), tr);
        return tr;
    }

    @FunctionType(functionName="Right", namingConflict=true, argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String right(String input, int i) {
        if (input == null || i < 0) {
            return null;
        }
        int ln = input.length();
        if (i >= ln) {
            return input;
        }
        return input.substring(ln - i, ln);
    }

    @FunctionType(functionName="\"RIGHT$\"", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String rightS(String input, int i) {
        return Functions.right(input, i);
    }

    @FunctionType(namingConflict=true, functionName="Round", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double round(double d, double p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    @FunctionType(namingConflict=true, functionName="Fix", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double fix(Double _number) {
        return _number == null ? null : Double.valueOf((double)Functions.sign(_number) * (double)Functions.mint(Math.abs(_number)).intValue());
    }

    @FunctionType(functionName="PARTITION", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String partition(Double _number, double start, double stop, double interval) {
        if (_number == null) {
            return null;
        }
        _number = Math.rint(_number);
        interval = Math.rint(interval);
        String ul = String.valueOf(Functions.lrint(stop) + 1);
        stop = Functions.lrint(stop);
        start = Functions.lrint(start);
        int h = ul.length();
        if (_number < start) {
            return Functions.padLeft(-1, h) + ":" + Functions.padLeft(Functions.lrint(start) - 1, h);
        }
        if (_number > stop) {
            return ul + ":" + Functions.padLeft(-1, h);
        }
        for (double d = start; d <= stop; d += interval) {
            if (!(_number >= d) || !(_number < d + interval)) continue;
            return Functions.padLeft(Functions.lceil(d), h) + ":" + Functions.padLeft(d + interval <= stop ? Functions.lfloor(d + interval) : Functions.lrint(stop), h);
        }
        return "";
    }

    private static int lfloor(double _d) {
        return (int)Math.floor(_d - 1.0E-8);
    }

    private static int lceil(double _d) {
        return (int)Math.ceil(_d - 1.0E-8);
    }

    private static int lrint(double _d) {
        return (int)Math.rint(_d - 1.0E-8);
    }

    private static String padLeft(int ext, int n) {
        String tp = ext > 0 ? String.valueOf(ext) : "";
        return String.format("%1$" + n + "s", tp);
    }
}

