/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.MalformedKeyException;

public class RequiredParameterReader
implements ParameterReadable {
    private final ParameterReadable src;

    public RequiredParameterReader(Header header) {
        this((ParameterReadable)Assert.isInstanceOf(ParameterReadable.class, (Object)header, (String)"Header implementations must implement ParameterReadable: "));
    }

    public RequiredParameterReader(ParameterReadable src) {
        this.src = (ParameterReadable)Assert.notNull((Object)src, (String)"Source ParameterReadable cannot be null.");
        Assert.isInstanceOf(Nameable.class, (Object)src, (String)"ParameterReadable implementations must implement Nameable.");
    }

    private String name() {
        return ((Nameable)((Object)this.src)).getName();
    }

    private JwtException malformed(String msg) {
        if (this.src instanceof JwkContext || this.src instanceof Jwk) {
            return new MalformedKeyException(msg);
        }
        return new MalformedJwtException(msg);
    }

    @Override
    public <T> T get(Parameter<T> param) {
        T value = this.src.get(param);
        if (value == null) {
            String msg = this.name() + " is missing required " + param + " value.";
            throw this.malformed(msg);
        }
        return value;
    }
}

