/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1NonResourceRule;
import io.kubernetes.client.openapi.models.V1NonResourceRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NonResourceRuleFluentImpl<A extends V1NonResourceRuleFluent<A>>
extends BaseFluent<A>
implements V1NonResourceRuleFluent<A> {
    private List<String> nonResourceURLs;
    private List<String> verbs;

    public V1NonResourceRuleFluentImpl() {
    }

    public V1NonResourceRuleFluentImpl(V1NonResourceRule instance) {
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNonResourceURLs(String ... items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNonResourceURLs(Collection<String> items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    @Override
    public String getNonResourceURL(Integer index) {
        return this.nonResourceURLs.get(index);
    }

    @Override
    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    @Override
    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    @Override
    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    @Override
    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    @Override
    public A addToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(Integer index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NonResourceRuleFluentImpl that = (V1NonResourceRuleFluentImpl)o;
        if (this.nonResourceURLs != null ? !this.nonResourceURLs.equals(that.nonResourceURLs) : that.nonResourceURLs != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty()) {
            sb.append("nonResourceURLs:");
            sb.append(this.nonResourceURLs + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(this.verbs);
        }
        sb.append("}");
        return sb.toString();
    }
}

