/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NamespaceCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NamespaceStatus is information about the current status of a Namespace.")
public class V1NamespaceStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1NamespaceCondition> conditions = null;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private String phase;

    public V1NamespaceStatus conditions(List<V1NamespaceCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1NamespaceStatus addConditionsItem(V1NamespaceCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NamespaceCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a namespace's current state.")
    public List<V1NamespaceCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1NamespaceCondition> conditions) {
        this.conditions = conditions;
    }

    public V1NamespaceStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/  ")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamespaceStatus v1NamespaceStatus = (V1NamespaceStatus)o;
        return Objects.equals(this.conditions, v1NamespaceStatus.conditions) && Objects.equals(this.phase, v1NamespaceStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.phase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamespaceStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

