/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Capabilities;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.")
public class V1SecurityContext {
    public static final String SERIALIZED_NAME_ALLOW_PRIVILEGE_ESCALATION = "allowPrivilegeEscalation";
    @SerializedName(value="allowPrivilegeEscalation")
    private Boolean allowPrivilegeEscalation;
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private V1Capabilities capabilities;
    public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
    @SerializedName(value="privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_PROC_MOUNT = "procMount";
    @SerializedName(value="procMount")
    private String procMount;
    public static final String SERIALIZED_NAME_READ_ONLY_ROOT_FILESYSTEM = "readOnlyRootFilesystem";
    @SerializedName(value="readOnlyRootFilesystem")
    private Boolean readOnlyRootFilesystem;
    public static final String SERIALIZED_NAME_RUN_AS_GROUP = "runAsGroup";
    @SerializedName(value="runAsGroup")
    private Long runAsGroup;
    public static final String SERIALIZED_NAME_RUN_AS_NON_ROOT = "runAsNonRoot";
    @SerializedName(value="runAsNonRoot")
    private Boolean runAsNonRoot;
    public static final String SERIALIZED_NAME_RUN_AS_USER = "runAsUser";
    @SerializedName(value="runAsUser")
    private Long runAsUser;
    public static final String SERIALIZED_NAME_SE_LINUX_OPTIONS = "seLinuxOptions";
    @SerializedName(value="seLinuxOptions")
    private V1SELinuxOptions seLinuxOptions;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE = "seccompProfile";
    @SerializedName(value="seccompProfile")
    private V1SeccompProfile seccompProfile;
    public static final String SERIALIZED_NAME_WINDOWS_OPTIONS = "windowsOptions";
    @SerializedName(value="windowsOptions")
    private V1WindowsSecurityContextOptions windowsOptions;

    public V1SecurityContext allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name is windows.")
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public V1SecurityContext capabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public V1SecurityContext privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name is windows.")
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public V1SecurityContext procMount(String procMount) {
        this.procMount = procMount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled. Note that this field cannot be set when spec.os.name is windows.")
    public String getProcMount() {
        return this.procMount;
    }

    public void setProcMount(String procMount) {
        this.procMount = procMount;
    }

    public V1SecurityContext readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container has a read-only root filesystem. Default is false. Note that this field cannot be set when spec.os.name is windows.")
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public V1SecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.")
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public V1SecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1SecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.")
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1SecurityContext seLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public V1SecurityContext seccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public V1SecurityContext windowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecurityContext v1SecurityContext = (V1SecurityContext)o;
        return Objects.equals(this.allowPrivilegeEscalation, v1SecurityContext.allowPrivilegeEscalation) && Objects.equals(this.capabilities, v1SecurityContext.capabilities) && Objects.equals(this.privileged, v1SecurityContext.privileged) && Objects.equals(this.procMount, v1SecurityContext.procMount) && Objects.equals(this.readOnlyRootFilesystem, v1SecurityContext.readOnlyRootFilesystem) && Objects.equals(this.runAsGroup, v1SecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, v1SecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1SecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, v1SecurityContext.seLinuxOptions) && Objects.equals(this.seccompProfile, v1SecurityContext.seccompProfile) && Objects.equals(this.windowsOptions, v1SecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecurityContext {\n");
        sb.append("    allowPrivilegeEscalation: ").append(this.toIndentedString(this.allowPrivilegeEscalation)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    procMount: ").append(this.toIndentedString(this.procMount)).append("\n");
        sb.append("    readOnlyRootFilesystem: ").append(this.toIndentedString(this.readOnlyRootFilesystem)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    seccompProfile: ").append(this.toIndentedString(this.seccompProfile)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

