/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.extended.kubectl.KubectlCordon;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import java.io.IOException;
import java.util.List;

public class KubectlDrain
extends KubectlCordon {
    private int timeoutSeconds = 30;
    private boolean force;
    private boolean ignoreDaemonSets;

    KubectlDrain() {
        super(true);
    }

    public KubectlDrain gracePeriod(int gracePeriodSeconds) {
        this.timeoutSeconds = gracePeriodSeconds;
        return this;
    }

    public KubectlDrain force() {
        this.force = true;
        return this;
    }

    public KubectlDrain ignoreDaemonSets() {
        this.ignoreDaemonSets = true;
        return this;
    }

    @Override
    public V1Node execute() throws KubectlException {
        try {
            this.refreshDiscovery();
            return this.doDrain();
        }
        catch (ApiException | IOException ex) {
            throw new KubectlException(ex);
        }
    }

    private V1Node doDrain() throws KubectlException, ApiException, IOException {
        CoreV1Api api = new CoreV1Api(this.apiClient);
        V1Node node = this.performCordon();
        V1PodList allPods = api.listPodForAllNamespaces(null, null, "spec.nodeName=" + node.getMetadata().getName(), null, null, null, null, null, null, null);
        this.validatePods(allPods.getItems());
        for (V1Pod pod : allPods.getItems()) {
            this.deletePod(api, pod.getMetadata().getName(), pod.getMetadata().getNamespace());
        }
        return node;
    }

    private void validatePods(List<V1Pod> pods) throws KubectlException {
        for (V1Pod pod : pods) {
            if (pod.getMetadata().getOwnerReferences() == null) continue;
            if (!this.force && pod.getMetadata().getOwnerReferences().size() == 0) {
                throw new KubectlException("Pods unmanaged by a controller are present on the node");
            }
            if (this.ignoreDaemonSets) continue;
            for (V1OwnerReference ref : pod.getMetadata().getOwnerReferences()) {
                if (!ref.getKind().equals("DaemonSet")) continue;
                throw new KubectlException("Pod managed by DaemonSet found");
            }
        }
    }

    private void deletePod(CoreV1Api api, String name, String namespace) throws ApiException, IOException, KubectlException {
        api.deleteNamespacedPod(name, namespace, null, null, Integer.valueOf(this.timeoutSeconds), null, null, null);
        this.waitForPodDelete(api, name, namespace);
    }

    private void waitForPodDelete(CoreV1Api api, String name, String namespace) throws KubectlException {
        long start = System.currentTimeMillis();
        do {
            try {
                api.readNamespacedPod(name, namespace, null);
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return;
                }
                throw new KubectlException(ex);
            }
        } while (System.currentTimeMillis() - start < (long)(this.timeoutSeconds * 1000));
        throw new KubectlException("Timed out waiting for Pod delete.");
    }
}

