/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.common;

import java.util.Map;
import lombok.NonNull;

public class IndexParam {
    @NonNull
    private String fieldName;
    private String indexName;
    private IndexType indexType;
    private MetricType metricType;
    private Map<String, Object> extraParams;

    private static IndexType $default$indexType() {
        return IndexType.AUTOINDEX;
    }

    protected IndexParam(IndexParamBuilder<?, ?> b) {
        this.fieldName = ((IndexParamBuilder)b).fieldName;
        if (this.fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.indexName = ((IndexParamBuilder)b).indexName;
        this.indexType = ((IndexParamBuilder)b).indexType$set ? ((IndexParamBuilder)b).indexType$value : IndexParam.$default$indexType();
        this.metricType = ((IndexParamBuilder)b).metricType;
        this.extraParams = ((IndexParamBuilder)b).extraParams;
    }

    public static IndexParamBuilder<?, ?> builder() {
        return new IndexParamBuilderImpl();
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setFieldName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexParam)) {
            return false;
        }
        IndexParam other = (IndexParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        IndexType this$indexType = this.getIndexType();
        IndexType other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType)) {
            return false;
        }
        MetricType this$metricType = this.getMetricType();
        MetricType other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !((Object)((Object)this$metricType)).equals((Object)other$metricType)) {
            return false;
        }
        Map<String, Object> this$extraParams = this.getExtraParams();
        Map<String, Object> other$extraParams = other.getExtraParams();
        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        IndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
        MetricType $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : ((Object)((Object)$metricType)).hashCode());
        Map<String, Object> $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        return result;
    }

    public String toString() {
        return "IndexParam(fieldName=" + this.getFieldName() + ", indexName=" + this.getIndexName() + ", indexType=" + (Object)((Object)this.getIndexType()) + ", metricType=" + (Object)((Object)this.getMetricType()) + ", extraParams=" + this.getExtraParams() + ")";
    }

    private static final class IndexParamBuilderImpl
    extends IndexParamBuilder<IndexParam, IndexParamBuilderImpl> {
        private IndexParamBuilderImpl() {
        }

        @Override
        protected IndexParamBuilderImpl self() {
            return this;
        }

        @Override
        public IndexParam build() {
            return new IndexParam(this);
        }
    }

    public static abstract class IndexParamBuilder<C extends IndexParam, B extends IndexParamBuilder<C, B>> {
        private String fieldName;
        private String indexName;
        private boolean indexType$set;
        private IndexType indexType$value;
        private MetricType metricType;
        private Map<String, Object> extraParams;

        protected abstract B self();

        public abstract C build();

        public B fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this.self();
        }

        public B indexName(String indexName) {
            this.indexName = indexName;
            return this.self();
        }

        public B indexType(IndexType indexType) {
            this.indexType$value = indexType;
            this.indexType$set = true;
            return this.self();
        }

        public B metricType(MetricType metricType) {
            this.metricType = metricType;
            return this.self();
        }

        public B extraParams(Map<String, Object> extraParams) {
            this.extraParams = extraParams;
            return this.self();
        }

        public String toString() {
            return "IndexParam.IndexParamBuilder(fieldName=" + this.fieldName + ", indexName=" + this.indexName + ", indexType$value=" + (Object)((Object)this.indexType$value) + ", metricType=" + (Object)((Object)this.metricType) + ", extraParams=" + this.extraParams + ")";
        }
    }

    public static enum IndexType {
        None(0),
        FLAT(1),
        IVF_FLAT(2),
        IVF_SQ8(3),
        IVF_PQ(4),
        HNSW(5),
        HNSW_SQ(6),
        HNSW_PQ(7),
        HNSW_PRQ(8),
        DISKANN(10),
        AUTOINDEX(11),
        SCANN(12),
        IVF_RABITQ(13),
        GPU_IVF_FLAT(50),
        GPU_IVF_PQ(51),
        GPU_BRUTE_FORCE(52),
        GPU_CAGRA(53),
        BIN_FLAT(80),
        BIN_IVF_FLAT(81),
        MINHASH_LSH(82),
        TRIE("Trie", 100),
        STL_SORT(200),
        INVERTED(201),
        BITMAP(202),
        SPARSE_INVERTED_INDEX(300),
        SPARSE_WAND(301);

        private final String name;
        private final int code;

        private IndexType() {
            this.name = this.toString();
            this.code = this.ordinal();
        }

        private IndexType(int code) {
            this.name = this.toString();
            this.code = code;
        }

        private IndexType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum MetricType {
        INVALID,
        L2,
        IP,
        COSINE,
        HAMMING,
        JACCARD,
        MHJACCARD,
        BM25;

    }
}

