/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class FailureInfo {
    private final String message;
    private final Map<String, String> metadata;
    private final @Nullable String detailsJson;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(FailureInfo failure) {
        return new Builder(failure);
    }

    private FailureInfo(String message, Map<String, String> metadata, @Nullable String detailsJson) {
        this.message = message;
        this.metadata = metadata;
        this.detailsJson = detailsJson;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public @Nullable String getDetailsJson() {
        return this.detailsJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailureInfo that = (FailureInfo)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.detailsJson, that.detailsJson);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.metadata, this.detailsJson);
    }

    public String toString() {
        return "OperationFailure{message='" + this.message + '\'' + ", metadata=" + this.metadata + ", details=" + this.detailsJson + '}';
    }

    public static class Builder {
        private @Nullable String message;
        private final Map<String, String> metadata;
        private @Nullable String detailsJson;

        private Builder() {
            this.metadata = new HashMap<String, String>();
        }

        private Builder(FailureInfo failure) {
            this.message = failure.message;
            this.metadata = new HashMap<String, String>(failure.metadata);
            this.detailsJson = failure.detailsJson;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Builder putMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder setDetailsJson(@Nullable String detailsJson) {
            this.detailsJson = detailsJson;
            return this;
        }

        public FailureInfo build() {
            Objects.requireNonNull(this.message, "Message required");
            return new FailureInfo(this.message, Collections.unmodifiableMap(new HashMap<String, String>(this.metadata)), this.detailsJson);
        }
    }
}

