/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import java.net.URI;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class Link {
    private final URI uri;
    private final String type;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Link info) {
        return new Builder(info);
    }

    private Link(URI uri, String type) {
        this.uri = uri;
        this.type = type;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.uri, link.uri) && Objects.equals(this.type, link.type);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.type);
    }

    public String toString() {
        return "Link{uri=" + this.uri + ", type='" + this.type + '\'' + '}';
    }

    public static class Builder {
        private @Nullable URI uri;
        private @Nullable String type;

        private Builder() {
        }

        private Builder(Link link) {
            this.uri = link.uri;
            this.type = link.type;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Link build() {
            Objects.requireNonNull(this.uri, "URI required");
            Objects.requireNonNull(this.type, "Type required");
            return new Link(this.uri, this.type);
        }
    }
}

