/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import io.nexusrpc.OperationState;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OperationInfo {
    private final String token;
    private final OperationState state;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationInfo info) {
        return new Builder(info);
    }

    private OperationInfo(String token, OperationState state) {
        this.token = token;
        this.state = state;
    }

    public OperationState getState() {
        return this.state;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationInfo that = (OperationInfo)o;
        return Objects.equals(this.token, that.token) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.token, this.state});
    }

    public String toString() {
        return "OperationInfo{token='" + this.token + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static class Builder {
        private @Nullable String token;
        private @Nullable OperationState state;

        private Builder() {
        }

        private Builder(OperationInfo info) {
            this.token = info.token;
            this.state = info.state;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setState(OperationState state) {
            this.state = state;
            return this;
        }

        public OperationInfo build() {
            Objects.requireNonNull(this.token, "Operation Token required");
            Objects.requireNonNull(this.state, "State required");
            return new OperationInfo(this.token, this.state);
        }
    }
}

