/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import io.nexusrpc.OperationDefinition;
import io.nexusrpc.Service;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class ServiceDefinition {
    private final String name;
    private final Map<String, OperationDefinition> operations;

    public static ServiceDefinition fromClass(Class<?> clazz) {
        Service service = clazz.getDeclaredAnnotation(Service.class);
        if (service == null) {
            throw new IllegalArgumentException("Missing @Service annotation");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Must be an interface");
        }
        String name = service.name().isEmpty() ? clazz.getSimpleName() : service.name();
        Builder builder = ServiceDefinition.newBuilder().setName(name);
        LinkedHashSet interfaces = new LinkedHashSet();
        ArrayList<List<Method>> methods = new ArrayList<List<Method>>();
        ServiceDefinition.collectInterfaceInfo(clazz, interfaces, methods);
        for (Class clazz2 : interfaces) {
            String subName;
            Service service2 = clazz2.getDeclaredAnnotation(Service.class);
            if (service2 == null || name.equals(subName = service2.name().isEmpty() ? clazz2.getSimpleName() : service2.name())) continue;
            throw new IllegalArgumentException("Interface " + clazz2.getName() + " has a service annotation whose name (" + subName + ") does not match the expected name on the final interface (" + name + ")");
        }
        ArrayList<String> operationFailures = new ArrayList<String>();
        block3: for (List list : methods) {
            OperationDefinition firstOperation = null;
            for (Method method : list) {
                try {
                    OperationDefinition thisOperation = OperationDefinition.fromMethod(method);
                    if (firstOperation == null) {
                        firstOperation = thisOperation;
                        builder.addOperation(firstOperation);
                        continue;
                    }
                    if (firstOperation.equals(thisOperation)) continue;
                    operationFailures.add("Operation definition on " + method.getName() + " on " + method.getDeclaringClass().getName() + " mismatches against another operation of the same name/signature in the hierarchy");
                }
                catch (Exception e) {
                    operationFailures.add("Operation definition on " + method.getName() + " on " + method.getDeclaringClass().getName() + " is invalid: " + e.getMessage());
                }
                continue block3;
            }
        }
        if (!operationFailures.isEmpty()) {
            throw new IllegalArgumentException(operationFailures.size() + " operation(s) were invalid, reasons: " + String.join((CharSequence)", ", operationFailures));
        }
        return builder.build();
    }

    private static void collectInterfaceInfo(Class<?> iface, Set<Class<?>> interfaces, List<List<Method>> methods) {
        interfaces.add(iface);
        for (Method method : iface.getDeclaredMethods()) {
            methods.stream().filter(possible -> ((Method)possible.get(0)).getName().equals(method.getName()) && Arrays.equals(((Method)possible.get(0)).getGenericParameterTypes(), method.getGenericParameterTypes())).findFirst().orElseGet(() -> {
                ArrayList newList = new ArrayList();
                methods.add(newList);
                return newList;
            }).add(method);
        }
        for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
            if (interfaces.contains(genericDeclaration)) continue;
            ServiceDefinition.collectInterfaceInfo(genericDeclaration, interfaces, methods);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ServiceDefinition definition) {
        return new Builder(definition);
    }

    private ServiceDefinition(String name, Map<String, OperationDefinition> operations) {
        this.name = name;
        this.operations = operations;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, OperationDefinition> getOperations() {
        return this.operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDefinition that = (ServiceDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operations);
    }

    public String toString() {
        return "ServiceDefinition{name='" + this.name + '\'' + ", operations=" + this.operations + '}';
    }

    public static class Builder {
        private @Nullable String name;
        private final List<OperationDefinition> operations;

        private Builder() {
            this.operations = new ArrayList<OperationDefinition>();
        }

        private Builder(ServiceDefinition definition) {
            this.name = definition.name;
            this.operations = new ArrayList(definition.operations.values());
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<OperationDefinition> getOperations() {
            return this.operations;
        }

        public Builder addOperation(OperationDefinition definition) {
            this.operations.add(definition);
            return this;
        }

        public ServiceDefinition build() {
            Objects.requireNonNull(this.name, "Name required");
            if (this.operations.isEmpty()) {
                throw new IllegalStateException("No operations defined");
            }
            HashMap<String, OperationDefinition> definitions = new HashMap<String, OperationDefinition>(this.operations.size());
            for (OperationDefinition operation : this.operations) {
                if (definitions.containsKey(operation.getName())) {
                    throw new IllegalStateException("Multiple operations named '" + operation.getName() + "'");
                }
                if (operation.getMethodName() != null && definitions.values().stream().anyMatch(other -> operation.getMethodName().equals(other.getMethodName()))) {
                    throw new IllegalStateException("Multiple operations on the same method name of '" + operation.getMethodName() + "'");
                }
                definitions.put(operation.getName(), operation);
            }
            return new ServiceDefinition(this.name, Collections.unmodifiableMap(definitions));
        }
    }
}

