/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public class HandlerException
extends RuntimeException {
    private final String rawErrorType;
    private final ErrorType errorType;
    private final RetryBehavior retryBehavior;

    public HandlerException(ErrorType errorType, String message) {
        this(errorType, (Throwable)new RuntimeException(message), RetryBehavior.UNSPECIFIED);
    }

    public HandlerException(ErrorType errorType, String message, RetryBehavior retryBehavior) {
        this(errorType, (Throwable)new RuntimeException(message), retryBehavior);
    }

    public HandlerException(ErrorType errorType, @Nullable Throwable cause) {
        this(errorType, cause, RetryBehavior.UNSPECIFIED);
    }

    public HandlerException(ErrorType errorType, @Nullable Throwable cause, RetryBehavior retryBehavior) {
        super(cause == null ? "handler error" : "handler error: " + cause.getMessage(), cause);
        this.rawErrorType = errorType.name();
        this.errorType = errorType;
        this.retryBehavior = retryBehavior;
    }

    public HandlerException(String rawErrorType, @Nullable Throwable cause, RetryBehavior retryBehavior) {
        super(cause == null ? "handler error" : "handler error: " + cause.getMessage(), cause);
        this.rawErrorType = rawErrorType;
        this.errorType = Arrays.stream(ErrorType.values()).anyMatch(t -> t.name().equals(rawErrorType)) ? ErrorType.valueOf(rawErrorType) : ErrorType.UNKNOWN;
        this.retryBehavior = retryBehavior;
    }

    public String getRawErrorType() {
        return this.rawErrorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public RetryBehavior getRetryBehavior() {
        return this.retryBehavior;
    }

    public boolean isRetryable() {
        if (this.retryBehavior != RetryBehavior.UNSPECIFIED) {
            return this.retryBehavior == RetryBehavior.RETRYABLE;
        }
        switch (this.errorType) {
            case BAD_REQUEST: 
            case UNAUTHENTICATED: 
            case UNAUTHORIZED: 
            case NOT_FOUND: 
            case NOT_IMPLEMENTED: {
                return false;
            }
        }
        return true;
    }

    public static enum ErrorType {
        UNKNOWN,
        BAD_REQUEST,
        UNAUTHENTICATED,
        UNAUTHORIZED,
        NOT_FOUND,
        RESOURCE_EXHAUSTED,
        INTERNAL,
        NOT_IMPLEMENTED,
        UNAVAILABLE,
        UPSTREAM_TIMEOUT;

    }

    public static enum RetryBehavior {
        UNSPECIFIED,
        RETRYABLE,
        NON_RETRYABLE;

    }
}

