/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;

public final class KafkaProducerRequest {
    private final ProducerRecord<?, ?> record;
    @Nullable
    private final String clientId;

    public static KafkaProducerRequest create(ProducerRecord<?, ?> record, Producer<?, ?> producer) {
        return KafkaProducerRequest.create(record, KafkaProducerRequest.extractClientId(producer));
    }

    public static KafkaProducerRequest create(ProducerRecord<?, ?> record, String clientId) {
        return new KafkaProducerRequest(record, clientId);
    }

    private KafkaProducerRequest(ProducerRecord<?, ?> record, String clientId) {
        this.record = record;
        this.clientId = clientId;
    }

    public ProducerRecord<?, ?> getRecord() {
        return this.record;
    }

    public String getClientId() {
        return this.clientId;
    }

    private static String extractClientId(Producer<?, ?> producer) {
        try {
            Map metrics = producer.metrics();
            Iterator metricIterator = metrics.keySet().iterator();
            return metricIterator.hasNext() ? (String)((MetricName)metricIterator.next()).tags().get("client-id") : null;
        }
        catch (RuntimeException exception) {
            return null;
        }
    }
}

