/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoTelemetry;

public final class MongoTelemetryBuilder {
    static final int DEFAULT_MAX_NORMALIZED_QUERY_LENGTH = 32768;
    private final OpenTelemetry openTelemetry;
    private boolean statementSanitizationEnabled = true;
    private int maxNormalizedQueryLength = 32768;

    MongoTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public MongoTelemetryBuilder setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    @CanIgnoreReturnValue
    public MongoTelemetryBuilder setMaxNormalizedQueryLength(int maxNormalizedQueryLength) {
        this.maxNormalizedQueryLength = maxNormalizedQueryLength;
        return this;
    }

    public MongoTelemetry build() {
        return new MongoTelemetry(this.openTelemetry, this.statementSanitizationEnabled, this.maxNormalizedQueryLength);
    }
}

