/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.instrumentation.resources.internal.MainJarPathFinder;
import io.opentelemetry.instrumentation.resources.internal.MainJarPathHolder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JarServiceNameResourceExtractor {
    private static final Logger logger = Logger.getLogger(JarServiceNameResourceExtractor.class.getName());
    private final Supplier<Optional<Path>> jarPathSupplier;

    public JarServiceNameResourceExtractor() {
        this(MainJarPathHolder::getJarPath);
    }

    JarServiceNameResourceExtractor(MainJarPathFinder jarPathFinder) {
        this(() -> Optional.ofNullable(jarPathFinder.detectJarPath()));
    }

    private JarServiceNameResourceExtractor(Supplier<Optional<Path>> jarPathSupplier) {
        this.jarPathSupplier = jarPathSupplier;
    }

    public Resource extract() {
        return this.jarPathSupplier.get().map(jarPath -> {
            String serviceName = JarServiceNameResourceExtractor.getServiceName(jarPath);
            logger.log(Level.FINE, "Auto-detected service name from the jar file name: {0}", serviceName);
            return Resource.create((Attributes)Attributes.of((AttributeKey)ServiceAttributes.SERVICE_NAME, (Object)serviceName));
        }).orElseGet(Resource::empty);
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }
}

