/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.kafka;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.kafka.ConcurrentKafkaListenerContainerFactoryPostProcessor;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.SpringKafkaTelemetry;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.KafkaTemplate;

@ConditionalOnEnabledInstrumentation(module="kafka")
@ConditionalOnClass(value={KafkaTemplate.class, ConcurrentKafkaListenerContainerFactory.class, DefaultKafkaProducerFactoryCustomizer.class})
@Configuration
public class KafkaInstrumentationAutoConfiguration {
    @Bean
    DefaultKafkaProducerFactoryCustomizer otelKafkaProducerFactoryCustomizer(OpenTelemetry openTelemetry) {
        KafkaTelemetry kafkaTelemetry = KafkaTelemetry.create((OpenTelemetry)openTelemetry);
        return producerFactory -> producerFactory.addPostProcessor(arg_0 -> ((KafkaTelemetry)kafkaTelemetry).wrap(arg_0));
    }

    @Bean
    static SpringKafkaTelemetry getTelemetry(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        return SpringKafkaTelemetry.builder((OpenTelemetry)((OpenTelemetry)openTelemetryProvider.getObject())).setCaptureExperimentalSpanAttributes(((ConfigProperties)configPropertiesProvider.getObject()).getBoolean("otel.instrumentation.kafka.experimental-span-attributes", false)).build();
    }

    @Bean
    @ConditionalOnProperty(name={"otel.instrumentation.kafka.autoconfigure-interceptor"}, havingValue="true", matchIfMissing=true)
    static ConcurrentKafkaListenerContainerFactoryPostProcessor otelKafkaListenerContainerFactoryBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        return new ConcurrentKafkaListenerContainerFactoryPostProcessor(() -> KafkaInstrumentationAutoConfiguration.getTelemetry(openTelemetryProvider, configPropertiesProvider));
    }
}

