/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.annotations;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.SpanNames;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

final class JoinPointRequest {
    private final JoinPoint joinPoint;
    private final Method method;
    private final String spanName;
    private final SpanKind spanKind;

    private JoinPointRequest(JoinPoint joinPoint, Method method, String spanName, SpanKind spanKind) {
        if (spanName.isEmpty()) {
            spanName = SpanNames.fromMethod((Method)method);
        }
        this.joinPoint = joinPoint;
        this.method = method;
        this.spanName = spanName;
        this.spanKind = spanKind;
    }

    String spanName() {
        return this.spanName;
    }

    SpanKind spanKind() {
        return this.spanKind;
    }

    Method method() {
        return this.method;
    }

    Object[] args() {
        return this.joinPoint.getArgs();
    }

    static final class InstrumentationAnnotationFactory
    implements Factory {
        InstrumentationAnnotationFactory() {
        }

        @Override
        public JoinPointRequest create(JoinPoint joinPoint) {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            WithSpan annotation = method.getDeclaredAnnotation(WithSpan.class);
            String spanName = annotation != null ? annotation.value() : "";
            SpanKind spanKind = annotation != null ? annotation.kind() : SpanKind.INTERNAL;
            return new JoinPointRequest(joinPoint, method, spanName, spanKind);
        }
    }

    static interface Factory {
        public JoinPointRequest create(JoinPoint var1);
    }
}

