/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.HttpHeadersSetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.TraceWebClientSubscriber;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

public class WebClientTracingFilter
implements ExchangeFilterFunction {
    private final Instrumenter<ClientRequest, ClientResponse> instrumenter;
    private final ContextPropagators propagators;

    public WebClientTracingFilter(Instrumenter<ClientRequest, ClientResponse> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return new MonoWebClientTrace(request, next);
    }

    private final class MonoWebClientTrace
    extends Mono<ClientResponse> {
        private final ExchangeFunction next;
        private final ClientRequest request;

        private MonoWebClientTrace(ClientRequest request, ExchangeFunction next) {
            this.next = next;
            this.request = request;
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            Context parentContext = Context.current();
            if (!WebClientTracingFilter.this.instrumenter.shouldStart(parentContext, (Object)this.request)) {
                this.next.exchange(this.request).subscribe(subscriber);
                return;
            }
            Context context = WebClientTracingFilter.this.instrumenter.start(parentContext, (Object)this.request);
            ClientRequest.Builder builder = ClientRequest.from((ClientRequest)this.request);
            WebClientTracingFilter.this.propagators.getTextMapPropagator().inject(context, (Object)builder, (TextMapSetter)HttpHeadersSetter.INSTANCE);
            try (Scope ignored = context.makeCurrent();){
                this.next.exchange(builder.build()).doOnCancel(() -> WebClientTracingFilter.this.instrumenter.end(context, (Object)this.request, null, null)).subscribe((CoreSubscriber)new TraceWebClientSubscriber((Instrumenter<ClientRequest, ClientResponse>)WebClientTracingFilter.this.instrumenter, this.request, subscriber, context, parentContext));
            }
        }
    }
}

