/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.util.Classes;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.XMath;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.InternationalString;

public class Category
implements Serializable {
    private static final long serialVersionUID = 6215962897884256696L;
    private static final NumberRange<Byte> BYTE_0;
    private static final NumberRange<Byte> BYTE_1;
    private static final Color TRANSPARENT;
    public static final Category NODATA;
    public static final Category FALSE;
    public static final Category TRUE;
    private final InternationalString name;
    final double minimum;
    final double maximum;
    NumberRange<? extends Number> range;
    final boolean isQuantitative;
    private final int[] ARGB;
    private static final int[] DEFAULT;
    private static final Color[] CYCLE;

    public Category(CharSequence name, Color color, boolean sample) {
        this(name, Category.toArray(color), sample ? BYTE_0 : BYTE_1, false);
    }

    public Category(CharSequence name, Color color, int sample) {
        this(name, Category.toARGB(color, sample), (Number)sample, false);
        assert (this.minimum == (double)sample) : this.minimum;
        assert (this.maximum == (double)sample) : this.maximum;
    }

    public Category(CharSequence name, Color color, int sample, boolean isQuantitative) {
        this(name, Category.toARGB(color, sample), (Number)sample, isQuantitative);
        assert (this.minimum == (double)sample) : this.minimum;
        assert (this.maximum == (double)sample) : this.maximum;
    }

    public Category(CharSequence name, Color color, double sample) {
        this(name, Category.toARGB(color, (int)sample), sample, false);
        assert (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(sample)) : this.minimum;
        assert (Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(sample)) : this.maximum;
    }

    private Category(CharSequence name, int[] ARGB, Number sample, boolean isQuantitative) {
        this(name, ARGB, new NumberRange(sample.getClass(), sample, sample), isQuantitative);
    }

    public Category(CharSequence name, Color color, NumberRange<?> sampleValueRange) throws IllegalArgumentException {
        this(name, Category.toArray(color), sampleValueRange, true);
    }

    public Category(CharSequence name, Color[] colors, int lower, int upper) throws IllegalArgumentException {
        this(name, colors, NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false));
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange) throws IllegalArgumentException {
        this(name, colors, sampleValueRange, true);
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, boolean isQuantitative) throws IllegalArgumentException {
        this(name, Category.toARGB(colors), sampleValueRange, isQuantitative);
    }

    private Category(CharSequence name, int[] ARGB, NumberRange range, boolean isQuantitative) throws IllegalArgumentException {
        Category.ensureNonNull("name", name);
        this.name = SimpleInternationalString.wrap((CharSequence)name);
        this.ARGB = ARGB;
        this.range = range;
        Class type = range.getElementClass();
        boolean minInc = range.isMinIncluded();
        boolean maxInc = range.isMaxIncluded();
        this.minimum = Category.doubleValue(type, range.getMinValue(), minInc ? 0 : 1);
        this.maximum = Category.doubleValue(type, range.getMaxValue(), maxInc ? 0 : -1);
        if (minInc && maxInc && Double.isNaN(this.minimum) && Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(this.maximum)) {
            this.isQuantitative = false;
            return;
        }
        this.isQuantitative = isQuantitative;
        if (!(this.minimum <= this.maximum) || Double.isInfinite(this.minimum) || Double.isInfinite(this.maximum)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)range.getMinValue(), (Object)range.getMaxValue()));
        }
    }

    static MathTransform1D createLinearTransform(double scale, double offset) {
        return LinearTransform1D.create((double)scale, (double)offset);
    }

    private static double doubleValue(Class<?> type, Comparable number, int direction) {
        assert (direction >= -1 && direction <= 1) : direction;
        return XMath.rool(type, (double)((Number)((Object)number)).doubleValue(), (int)direction);
    }

    private static Color[] toArray(Color color) {
        Color[] colorArray;
        if (color != null) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = color;
        } else {
            colorArray = null;
        }
        return colorArray;
    }

    private static int[] toARGB(Color[] colors) {
        int[] ARGB;
        if (colors != null && colors.length != 0) {
            ARGB = new int[colors.length];
            for (int i = 0; i < ARGB.length; ++i) {
                Color color = colors[i];
                if (color == null) continue;
                ARGB[i] = color.getRGB();
            }
        } else {
            ARGB = DEFAULT;
        }
        return ARGB;
    }

    private static int[] toARGB(Color color, int sample) {
        if (color == null) {
            color = CYCLE[Math.abs(sample) % CYCLE.length];
        }
        return new int[]{color.getRGB()};
    }

    public InternationalString getName() {
        return this.name;
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.ARGB.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(this.ARGB[i], true);
        }
        return colors;
    }

    public NumberRange<? extends Number> getRange() {
        assert (this.range != null);
        return this.range;
    }

    public boolean isQuantitative() {
        return this.isQuantitative;
    }

    public Category recolor(Color[] colors) {
        int[] newARGB = Category.toARGB(colors);
        if (Arrays.equals(this.ARGB, newARGB)) {
            return this;
        }
        assert (this.range != null) : this;
        Category newCategory = new Category((CharSequence)this.name, newARGB, this.range, this.isQuantitative);
        return newCategory;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Category that = (Category)object;
            if (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(that.minimum) && Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(that.maximum) && Utilities.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.ARGB, that.ARGB)) {
                if (this.range != null && that.range != null) {
                    return Utilities.equals(this.range, that.range);
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this));
        buffer.append("(\"").append((CharSequence)this.name).append("\":[");
        if (Classes.isInteger((Class)this.getRange().getElementClass())) {
            buffer.append(Math.round(this.minimum)).append("...").append(Math.round(this.maximum));
        } else {
            buffer.append(this.minimum).append(" ... ").append(this.maximum);
        }
        return buffer.append("])").toString();
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)name));
        }
    }

    static {
        Byte index = 0;
        BYTE_0 = NumberRange.create((byte)index, (byte)index);
        index = 1;
        BYTE_1 = NumberRange.create((byte)index, (byte)index);
        TRANSPARENT = new Color(0, 0, 0, 0);
        NODATA = new Category((CharSequence)Vocabulary.formatInternational((int)147), TRANSPARENT, 0, false);
        FALSE = new Category((CharSequence)Vocabulary.formatInternational((int)70), Color.BLACK, false);
        TRUE = new Category((CharSequence)Vocabulary.formatInternational((int)226), Color.WHITE, true);
        DEFAULT = new int[]{-16777216, -1};
        CYCLE = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.YELLOW, Color.PINK, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.LIGHT_GRAY, Color.GRAY};
    }
}

