/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import org.geotools.util.Utilities;

public final class PixelScale {
    private double scaleX = Double.NaN;
    private double scaleY = Double.NaN;
    private double scaleZ = Double.NaN;

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof PixelScale)) {
            return false;
        }
        PixelScale thatO = (PixelScale)that;
        return Utilities.equals((double)this.scaleX, (double)thatO.scaleX) && Utilities.equals((double)this.scaleY, (double)thatO.scaleY) && Utilities.equals((double)this.scaleZ, (double)thatO.scaleZ);
    }

    public int hashCode() {
        int hash = Utilities.hash((double)this.scaleX, (int)1);
        hash = Utilities.hash((double)this.scaleY, (int)hash);
        hash = Utilities.hash((double)this.scaleZ, (int)hash);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Pixel Scale").append("\n");
        buf.append("\tscaleX=").append(this.scaleX).append(" is set? ").append(this.isComponentSet(this.scaleX)).append("\n");
        buf.append("\tscaleY=").append(this.scaleY).append(" is set? ").append(this.isComponentSet(this.scaleY)).append("\n");
        buf.append("\tscaleZ=").append(this.scaleZ).append(" is set? ").append(this.isComponentSet(this.scaleZ)).append("\n");
        return buf.toString();
    }

    public PixelScale(double scaleX, double scaleY, double scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public PixelScale() {
        this.scaleX = 0.0;
        this.scaleY = 0.0;
        this.scaleZ = 0.0;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public void setScaleZ(double scaleZ) {
        this.scaleZ = scaleZ;
    }

    public double[] getValues() {
        return new double[]{this.scaleX, this.scaleY, this.scaleZ};
    }

    public boolean isSet() {
        return this.isComponentSet(this.scaleX) && this.isComponentSet(this.scaleY);
    }

    public boolean isSetExtended() {
        return this.isComponentSet(this.scaleX) && this.isComponentSet(this.scaleY) && this.isComponentSet(this.scaleZ);
    }

    private boolean isComponentSet(double scale) {
        return !Double.isInfinite(scale) && !Double.isNaN(scale) && Math.abs(scale) > 1.0E-6;
    }
}

