/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations {
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation POSTGIS;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final Citation EPSG;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation CRS;
    public static final Citation URN_OGC;
    public static final Citation HTTP_OGC;
    public static final Citation HTTP_URI_OGC;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String title) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, title)) continue;
            return citation;
        }
        return new CitationImpl(title);
    }

    public static boolean titleMatches(Citation c1, Citation c2) {
        InternationalString candidate = c2.getTitle();
        Iterator iterator = null;
        while (true) {
            String asString;
            if (Citations.titleMatches(c1, asString = candidate.toString(null))) {
                return true;
            }
            String asLocalized = candidate.toString();
            if (!Objects.equals(asLocalized, asString) && Citations.titleMatches(c1, asLocalized)) {
                return true;
            }
            if (iterator == null) {
                Collection titles = c2.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String title) {
        title = title.trim();
        InternationalString candidate = citation.getTitle();
        Iterator iterator = null;
        while (true) {
            String asString;
            if ((asString = candidate.toString(null)).trim().equalsIgnoreCase(title)) {
                return true;
            }
            String asLocalized = candidate.toString();
            if (!Objects.equals(asLocalized, asString) && asLocalized.trim().equalsIgnoreCase(title)) {
                return true;
            }
            if (iterator == null) {
                Collection titles = citation.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean identifierMatches(Citation c1, Citation c2) {
        Iterator iterator = c2.getIdentifiers().iterator();
        if (!iterator.hasNext()) {
            iterator = c1.getIdentifiers().iterator();
            if (!iterator.hasNext()) {
                return Citations.titleMatches(c1, c2);
            }
            c1 = c2;
            c2 = null;
        }
        do {
            String id;
            if (!Citations.identifierMatches(c1, id = ((Identifier)iterator.next()).getCode().trim())) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    }

    public static boolean identifierMatches(Citation citation, String identifier) {
        identifier = identifier.trim();
        Collection identifiers = citation.getIdentifiers();
        for (Identifier id : identifiers) {
            String code = id.getCode().trim();
            if (!identifier.equalsIgnoreCase(code)) continue;
            return true;
        }
        if (identifiers.isEmpty()) {
            return Citations.titleMatches(citation, identifier);
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        String identifier = null;
        for (Identifier id : citation.getIdentifiers()) {
            String candidate = id.getCode().trim();
            int length = candidate.length();
            if (length == 0 || identifier != null && length >= identifier.length()) continue;
            identifier = candidate;
        }
        if (identifier == null) {
            identifier = String.valueOf(citation.getTitle());
        }
        return identifier;
    }

    static {
        CitationImpl c = new CitationImpl(ResponsiblePartyImpl.OGC);
        c.getAlternateTitles().add(new SimpleInternationalString("OGC"));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        OGC = c;
        c = new CitationImpl(ResponsiblePartyImpl.OPEN_GIS);
        Collection<InternationalString> alt = c.getAlternateTitles();
        alt.add(new SimpleInternationalString("OpenGIS"));
        alt.addAll(OGC.getAlternateTitles());
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        OPEN_GIS = c;
        c = new CitationImpl(ResponsiblePartyImpl.ESRI);
        c.addAuthority("ESRI", true);
        c.freeze();
        ESRI = c;
        c = new CitationImpl(ResponsiblePartyImpl.ORACLE);
        c.freeze();
        ORACLE = c;
        c = new CitationImpl(ResponsiblePartyImpl.POSTGIS);
        c.freeze();
        POSTGIS = c;
        c = new CitationImpl(ResponsiblePartyImpl.GEOTOOLS);
        c.freeze();
        GEOTOOLS = c;
        c = new CitationImpl("Web Map Service");
        Collection<InternationalString> titles = c.getAlternateTitles();
        titles.add(new SimpleInternationalString("WMS"));
        titles.add(new SimpleInternationalString("WMS 1.3.0"));
        titles.add(new SimpleInternationalString("OGC 04-024"));
        titles.add(new SimpleInternationalString("ISO 19128"));
        Collection<ResponsibleParty> parties = c.getCitedResponsibleParties();
        parties.add(ResponsiblePartyImpl.OGC);
        parties.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        WMS = c;
        c = new CitationImpl(ResponsiblePartyImpl.GEOTIFF);
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        GEOTIFF = c;
        c = new CitationImpl("Java Advanced Imaging");
        c.getAlternateTitles().add(new SimpleInternationalString("JAI"));
        c.getCitedResponsibleParties().add(ResponsiblePartyImpl.SUN_MICROSYSTEMS);
        c.freeze();
        JAI = c;
        c = new CitationImpl(ResponsiblePartyImpl.EPSG);
        c.addAuthority("EPSG", true);
        c.getPresentationForm().add(PresentationForm.TABLE_DIGITAL);
        c.freeze();
        EPSG = c;
        c = new CitationImpl("Automatic Projections");
        c.addAuthority("AUTO", false);
        Collection<ResponsibleParty> parties2 = c.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf"));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        AUTO = c;
        c = new CitationImpl("Automatic Projections");
        c.addAuthority("AUTO2", false);
        parties2 = c.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        AUTO2 = c;
        c = new CitationImpl("Web Map Service CRS");
        c.addAuthority("CRS", false);
        c.getCitedResponsibleParties().addAll(AUTO2.getCitedResponsibleParties());
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        CRS = c;
        c = new CitationImpl("URN in OGC namespace");
        c.addAuthority("urn:ogc:def", false);
        c.addAuthority("urn:x-ogc:def", false);
        c.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        URN_OGC = c;
        c = new CitationImpl("URL in OGC namespace");
        c.addAuthority("http://www.opengis.net/gml", false);
        c.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        HTTP_OGC = c;
        c = new CitationImpl("HTTP URI in OGC namespace");
        c.addAuthority("http://www.opengis.net/def", false);
        c.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        HTTP_URI_OGC = c;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, GEOTOOLS, WMS, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS};
    }
}

