/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.sql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geotools.metadata.sql.MetadataEntity;
import org.geotools.metadata.sql.MetadataException;
import org.geotools.metadata.sql.MetadataResult;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.MetaData;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class MetadataSource
implements AutoCloseable {
    final String metadataPackage = "org.opengis.metadata.";
    private final Connection connection;
    private final String query = "SELECT * FROM metadata.\"?\" WHERE id=?";
    private final String codeQuery = "SELECT name FROM metadata.\"?\" WHERE code=?";
    private final Map<Class<?>, MetadataResult> statements = new HashMap();
    private final Properties geoApiToIso = new Properties();
    private final Properties collectionTypes = new Properties();
    private final ClassLoader loader;

    public MetadataSource(Connection connection) {
        this.connection = connection;
        try {
            try (InputStream in = MetaData.class.getResourceAsStream("GeoAPI_to_ISO.properties");){
                this.geoApiToIso.load(in);
            }
            in = MetaData.class.getResourceAsStream("CollectionTypes.properties");
            try {
                if (in != null) {
                    this.collectionTypes.load(in);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException exception) {
            throw new MetadataException("Can't read resources.", exception);
        }
        this.loader = this.getClass().getClassLoader();
    }

    public synchronized Object getEntry(Class type, String identifier) throws SQLException {
        if (CodeList.class.isAssignableFrom(type)) {
            return this.getCodeList(type, identifier);
        }
        return Proxy.newProxyInstance(this.loader, new Class[]{type}, (InvocationHandler)new MetadataEntity(identifier, this));
    }

    final synchronized Object getValue(Class<?> type, Method method, String identifier) throws SQLException {
        String className = MetadataSource.getClassName(type);
        MetadataResult result = this.statements.get(type);
        if (result == null) {
            result = new MetadataResult(this.connection, "SELECT * FROM metadata.\"?\" WHERE id=?", this.getTableName(className));
            this.statements.put(type, result);
        }
        String columnName = this.getColumnName(className, method);
        Class<?> valueType = method.getReturnType();
        if (Collection.class.isAssignableFrom(valueType)) {
            AbstractCollection collection = List.class.isAssignableFrom(valueType) ? new ArrayList() : (SortedSet.class.isAssignableFrom(valueType) ? new TreeSet() : new LinkedHashSet());
            assert (valueType.isAssignableFrom(collection.getClass()));
            Object elements = result.getArray(identifier, columnName);
            if (elements != null) {
                Class elementType = this.getElementType(className, method);
                boolean isMetadata = this.isMetadata(elementType);
                int length = Array.getLength(elements);
                for (int i = 0; i < length; ++i) {
                    collection.add(isMetadata ? this.getEntry(elementType, Array.get(elements, i).toString()) : MetadataSource.convert(elementType, Array.get(elements, i)));
                }
            }
            return collection;
        }
        if (valueType.isInterface() && this.isMetadata(valueType)) {
            String foreigner = result.getString(identifier, columnName);
            return result.wasNull() ? null : this.getEntry(valueType, foreigner);
        }
        if (CodeList.class.isAssignableFrom(valueType)) {
            String foreigner = result.getString(identifier, columnName);
            return result.wasNull() ? null : this.getCodeList(valueType, foreigner);
        }
        return MetadataSource.convert(valueType, result.getObject(identifier, columnName));
    }

    private boolean isMetadata(Class valueType) {
        return valueType.getName().startsWith("org.opengis.metadata.");
    }

    private static Object convert(Class<?> valueType, Object value) {
        if (value != null && !valueType.isAssignableFrom(value.getClass())) {
            if (InternationalString.class.isAssignableFrom(valueType)) {
                return new SimpleInternationalString(value.toString());
            }
            if (URL.class.isAssignableFrom(valueType)) {
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException exception) {
                    throw new MetadataException("Illegal value.", exception);
                }
            }
            if (URI.class.isAssignableFrom(valueType)) {
                try {
                    return new URI(value.toString());
                }
                catch (URISyntaxException exception) {
                    throw new MetadataException("Illegal value.", exception);
                }
            }
        }
        return value;
    }

    private CodeList getCodeList(Class<?> type, String identifier) throws SQLException {
        CodeList candidate;
        CodeList[] values;
        boolean isNumerical;
        int code;
        assert (Thread.holdsLock(this));
        String className = MetadataSource.getClassName(type);
        try {
            code = Integer.parseInt(identifier);
            isNumerical = true;
        }
        catch (NumberFormatException exception) {
            code = 0;
            isNumerical = false;
        }
        if (isNumerical) {
            MetadataResult result = this.statements.get(type);
            if (result == null) {
                result = new MetadataResult(this.connection, "SELECT name FROM metadata.\"?\" WHERE code=?", this.getTableName(className));
                this.statements.put(type, result);
            }
            identifier = result.getString(identifier);
        }
        try {
            values = (CodeList[])type.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException exception) {
            throw new MetadataException("Can't read code list.", exception);
        }
        catch (IllegalAccessException exception) {
            throw new MetadataException("Can't read code list.", exception);
        }
        catch (InvocationTargetException exception) {
            throw new MetadataException("Can't read code list.", exception);
        }
        StringBuilder candidateName = new StringBuilder(className);
        candidateName.append('.');
        int base = candidateName.length();
        if (code >= 1 && code < values.length) {
            candidate = values[code - 1];
            candidateName.append(candidate.name());
            if (identifier.equals(this.geoApiToIso.getProperty(candidateName.toString()))) {
                return candidate;
            }
        }
        for (int i = 0; i < values.length; ++i) {
            candidate = values[i];
            candidateName.setLength(base);
            candidateName.append(candidate.name());
            if (!identifier.equals(this.geoApiToIso.getProperty(candidateName.toString()))) continue;
            return candidate;
        }
        throw new SQLException("Unknow code list: \"" + identifier + "\" in table \"" + this.getTableName(className) + '\"');
    }

    private static String getClassName(Class<?> type) {
        String className = type.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private String getTableName(String className) {
        String tableName = this.geoApiToIso.getProperty(className);
        return tableName != null ? tableName : className;
    }

    private String getColumnName(String className, Method method) {
        String methodName = method.getName();
        String columnName = this.geoApiToIso.getProperty(className + '.' + methodName);
        return columnName != null ? columnName : methodName;
    }

    private Class getElementType(String className, Method method) {
        String key = className + '.' + method.getName();
        String typeName = this.collectionTypes.getProperty(key);
        ClassNotFoundException cause = null;
        if (typeName != null) {
            try {
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException exception) {
                cause = exception;
            }
        }
        MetadataException e = new MetadataException("Unknow element type for " + key);
        if (cause != null) {
            e.initCause(cause);
        }
        throw e;
    }

    @Override
    public synchronized void close() throws SQLException {
        Iterator<MetadataResult> it = this.statements.values().iterator();
        while (it.hasNext()) {
            it.next().close();
            it.remove();
        }
        this.connection.close();
    }
}

