/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.geotools.util.SynchronizedIterator;
import org.opengis.util.Cloneable;

public class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedCollection<E>,
Cloneable {
    private static final long serialVersionUID = -9014541457174735097L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> type) {
        this.type = type;
        this.ensureNonNull();
    }

    public CheckedHashSet(Class<E> type, int capacity) {
        super(capacity);
        this.type = type;
        this.ensureNonNull();
    }

    private void ensureNonNull() {
        if (this.type == null) {
            throw new IllegalArgumentException(Errors.format(143, "type"));
        }
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    protected void ensureValidType(E element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format(61, element.getClass(), this.type));
        }
    }

    private void ensureValid(Collection<? extends E> collection) throws IllegalArgumentException {
        if (collection != null) {
            for (E element : collection) {
                this.ensureValidType(element);
            }
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return new SynchronizedIterator(super.iterator(), lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidType(element);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashSet<E> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashSet)super.clone();
        }
    }
}

