/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.replay.ReplayOperator;

public class MultiReplay {
    private long numberOfItemsToReplay = Long.MAX_VALUE;

    @CheckReturnValue
    public MultiReplay upTo(long numberOfItemsToReplay) {
        this.numberOfItemsToReplay = ParameterValidation.positive(numberOfItemsToReplay, "numberOfItemsToReplay");
        return this;
    }

    @CheckReturnValue
    public <T> Multi<T> ofMulti(Multi<T> upstream) {
        return new ReplayOperator<T>(ParameterValidation.nonNull(upstream, "upstream"), this.numberOfItemsToReplay);
    }

    @CheckReturnValue
    public <T> Multi<T> ofSeedAndMulti(Iterable<T> seed, Multi<T> upstream) {
        return new ReplayOperator<T>(ParameterValidation.nonNull(upstream, "upstream"), this.numberOfItemsToReplay, ParameterValidation.nonNull(seed, "seed"));
    }
}

