/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.BuildMetadataResolver;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;

public class WarPackagingWebStarterBuildCustomizer
implements BuildCustomizer<Build> {
    private final InitializrMetadata metadata;
    private final BuildMetadataResolver buildMetadataResolver;

    public WarPackagingWebStarterBuildCustomizer(InitializrMetadata metadata, ProjectDescription projectDescription) {
        this.metadata = metadata;
        this.buildMetadataResolver = new BuildMetadataResolver(metadata, projectDescription.getPlatformVersion());
    }

    @Override
    public void customize(Build build) {
        if (!this.buildMetadataResolver.hasFacet(build, "web")) {
            Dependency dependency = this.determineWebDependency(this.metadata);
            build.dependencies().add((Object)dependency.getId(), (Object)MetadataBuildItemMapper.toDependency((Dependency)dependency));
        }
        Dependency tomcat = Dependency.createSpringBootStarter((String)"tomcat");
        tomcat.setScope("provided");
        build.dependencies().add((Object)"tomcat", (Object)MetadataBuildItemMapper.toDependency((Dependency)tomcat));
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFF5;
    }

    private Dependency determineWebDependency(InitializrMetadata metadata) {
        Dependency web = metadata.getDependencies().get("web");
        return web != null ? web : Dependency.createSpringBootStarter((String)"web");
    }
}

