/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.gradle;

import io.spring.initializr.generator.buildsystem.BuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildWriter;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class GradleBuildProjectContributor
implements BuildWriter,
ProjectContributor {
    private final GradleBuildWriter buildWriter;
    private final GradleBuild build;
    private final IndentingWriterFactory indentingWriterFactory;
    private final String buildFileName;

    GradleBuildProjectContributor(GradleBuildWriter buildWriter, GradleBuild build, IndentingWriterFactory indentingWriterFactory, String buildFileName) {
        this.buildWriter = buildWriter;
        this.build = build;
        this.indentingWriterFactory = indentingWriterFactory;
        this.buildFileName = buildFileName;
    }

    public void contribute(Path projectRoot) throws IOException {
        Path buildGradle = Files.createFile(projectRoot.resolve(this.buildFileName), new FileAttribute[0]);
        this.writeBuild(Files.newBufferedWriter(buildGradle, new OpenOption[0]));
    }

    public void writeBuild(Writer out) throws IOException {
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("gradle", out);){
            this.buildWriter.writeTo(writer, this.build);
        }
    }
}

