/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.documentation;

import io.spring.initializr.generator.io.template.MustacheTemplateRenderer;
import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.generator.io.text.BulletedSection;
import io.spring.initializr.generator.io.text.Section;
import io.spring.initializr.generator.spring.documentation.PreDefinedSection;
import java.util.ArrayList;
import java.util.List;

public final class GettingStartedSection
extends PreDefinedSection {
    private final BulletedSection<Link> referenceDocs;
    private final BulletedSection<Link> guides;
    private final BulletedSection<Link> additionalLinks;

    GettingStartedSection(MustacheTemplateRenderer templateRenderer) {
        super("Getting Started");
        this.referenceDocs = new BulletedSection((TemplateRenderer)templateRenderer, "documentation/reference-documentation");
        this.guides = new BulletedSection((TemplateRenderer)templateRenderer, "documentation/guides");
        this.additionalLinks = new BulletedSection((TemplateRenderer)templateRenderer, "documentation/additional-links");
    }

    @Override
    public boolean isEmpty() {
        return this.referenceDocs().isEmpty() && this.guides().isEmpty() && this.additionalLinks().isEmpty() && super.isEmpty();
    }

    @Override
    protected List<Section> resolveSubSections(List<Section> sections) {
        ArrayList<Section> allSections = new ArrayList<Section>();
        allSections.add((Section)this.referenceDocs);
        allSections.add((Section)this.guides);
        allSections.add((Section)this.additionalLinks);
        allSections.addAll(sections);
        return allSections;
    }

    public GettingStartedSection addReferenceDocLink(String href, String description) {
        this.referenceDocs.addItem((Object)new Link(href, description));
        return this;
    }

    public BulletedSection<Link> referenceDocs() {
        return this.referenceDocs;
    }

    public GettingStartedSection addGuideLink(String href, String description) {
        this.guides.addItem((Object)new Link(href, description));
        return this;
    }

    public BulletedSection<Link> guides() {
        return this.guides;
    }

    public GettingStartedSection addAdditionalLink(String href, String description) {
        this.additionalLinks.addItem((Object)new Link(href, description));
        return this;
    }

    public BulletedSection<Link> additionalLinks() {
        return this.additionalLinks;
    }

    public static class Link {
        private final String href;
        private final String description;

        Link(String href, String description) {
            this.href = href;
            this.description = description;
        }

        public String getHref() {
            return this.href;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

