/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.scm.git;

import io.spring.initializr.generator.io.text.Section;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;

public class GitIgnore {
    private final GitIgnoreSection general = new GitIgnoreSection(null);
    private final GitIgnoreSection sts = new GitIgnoreSection("STS");
    private final GitIgnoreSection intellijIdea = new GitIgnoreSection("IntelliJ IDEA");
    private final GitIgnoreSection netBeans = new GitIgnoreSection("NetBeans");
    private final GitIgnoreSection vscode = new GitIgnoreSection("VS Code");
    private final List<GitIgnoreSection> sections = new ArrayList<GitIgnoreSection>(Arrays.asList(this.general, this.sts, this.intellijIdea, this.netBeans, this.vscode));

    public void write(PrintWriter writer) throws IOException {
        for (GitIgnoreSection section : this.sections) {
            section.write(writer);
        }
    }

    public void addSection(GitIgnoreSection section) {
        GitIgnoreSection existingSection = this.getSection(section.name);
        Assert.state((existingSection == null ? 1 : 0) != 0, () -> "Section with name '%s' already exists".formatted(section.name));
        this.sections.add(section);
    }

    public GitIgnoreSection addSectionIfAbsent(String sectionName) {
        GitIgnoreSection section = this.getSection(sectionName);
        if (section != null) {
            return section;
        }
        section = new GitIgnoreSection(sectionName);
        this.addSection(section);
        return section;
    }

    public GitIgnoreSection getSection(String sectionName) {
        if ("general".equalsIgnoreCase(sectionName)) {
            return this.general;
        }
        return this.sections.stream().filter(section -> section.name != null && section.name.equalsIgnoreCase(sectionName)).findAny().orElse(null);
    }

    public boolean isEmpty() {
        return this.sections.stream().allMatch(section -> section.items.isEmpty());
    }

    public GitIgnoreSection getGeneral() {
        return this.general;
    }

    public GitIgnoreSection getSts() {
        return this.sts;
    }

    public GitIgnoreSection getIntellijIdea() {
        return this.intellijIdea;
    }

    public GitIgnoreSection getNetBeans() {
        return this.netBeans;
    }

    public GitIgnoreSection getVscode() {
        return this.vscode;
    }

    public static class GitIgnoreSection
    implements Section {
        private final String name;
        private final LinkedList<String> items;

        public GitIgnoreSection(String name) {
            this.name = name;
            this.items = new LinkedList();
        }

        public void add(String ... items) {
            this.items.addAll(Arrays.asList(items));
        }

        public LinkedList<String> getItems() {
            return this.items;
        }

        public void write(PrintWriter writer) {
            if (!this.items.isEmpty()) {
                if (this.name != null) {
                    writer.println();
                    writer.println(String.format("### %s ###", this.name));
                }
                this.items.forEach(writer::println);
            }
        }
    }
}

