/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.DependenciesCapability;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyGroup;
import io.spring.initializr.metadata.Describable;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.MetadataElement;
import io.spring.initializr.metadata.SingleSelectCapability;
import io.spring.initializr.metadata.TextCapability;
import io.spring.initializr.metadata.Type;
import io.spring.initializr.metadata.TypeCapability;
import io.spring.initializr.web.mapper.InitializrMetadataJsonMapper;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.StringUtils;

public class InitializrMetadataV2JsonMapper
implements InitializrMetadataJsonMapper {
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
    private final TemplateVariables templateVariables = new TemplateVariables(new TemplateVariable[]{new TemplateVariable("dependencies", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("packaging", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("javaVersion", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("language", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("bootVersion", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("groupId", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("artifactId", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("version", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("name", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("description", TemplateVariable.VariableType.REQUEST_PARAM), new TemplateVariable("packageName", TemplateVariable.VariableType.REQUEST_PARAM)});

    protected JsonNodeFactory nodeFactory() {
        return nodeFactory;
    }

    @Override
    public String write(InitializrMetadata metadata, String appUrl) {
        ObjectNode delegate = nodeFactory.objectNode();
        this.links(delegate, metadata.getTypes().getContent(), appUrl);
        this.dependencies(delegate, metadata.getDependencies());
        this.type(delegate, metadata.getTypes());
        this.singleSelect(delegate, metadata.getPackagings());
        this.singleSelect(delegate, metadata.getJavaVersions());
        this.singleSelect(delegate, metadata.getLanguages());
        this.singleSelect(delegate, metadata.getBootVersions(), this::mapVersionMetadata, this::formatVersion);
        this.text(delegate, metadata.getGroupId());
        this.text(delegate, metadata.getArtifactId());
        this.text(delegate, metadata.getVersion());
        this.text(delegate, metadata.getName());
        this.text(delegate, metadata.getDescription());
        this.text(delegate, metadata.getPackageName());
        return delegate.toString();
    }

    protected ObjectNode links(ObjectNode parent, List<Type> types, String appUrl) {
        ObjectNode content = nodeFactory.objectNode();
        types.forEach(it -> content.set(it.getId(), (JsonNode)this.link(appUrl, (Type)it)));
        parent.set("_links", (JsonNode)content);
        return content;
    }

    protected ObjectNode link(String appUrl, Type type) {
        ObjectNode result = nodeFactory.objectNode();
        result.put("href", this.generateTemplatedUri(appUrl, type));
        result.put("templated", true);
        return result;
    }

    private String generateTemplatedUri(String appUrl, Type type) {
        Object uri = appUrl != null ? appUrl + type.getAction() : type.getAction();
        uri = (String)uri + "?type=" + type.getId();
        UriTemplate uriTemplate = UriTemplate.of((String)uri, (TemplateVariables)this.templateVariables);
        return uriTemplate.toString();
    }

    protected void dependencies(ObjectNode parent, DependenciesCapability capability) {
        ObjectNode dependencies = nodeFactory.objectNode();
        dependencies.put("type", capability.getType().getName());
        ArrayNode values = nodeFactory.arrayNode();
        values.addAll((Collection)capability.getContent().stream().map(this::mapDependencyGroup).collect(Collectors.toList()));
        dependencies.set("values", (JsonNode)values);
        parent.set(capability.getId(), (JsonNode)dependencies);
    }

    protected void type(ObjectNode parent, TypeCapability capability) {
        ObjectNode type = nodeFactory.objectNode();
        type.put("type", capability.getType().getName());
        Type defaultType = capability.getDefault();
        if (defaultType != null) {
            type.put("default", defaultType.getId());
        }
        ArrayNode values = nodeFactory.arrayNode();
        values.addAll((Collection)capability.getContent().stream().map(this::mapType).collect(Collectors.toList()));
        type.set("values", (JsonNode)values);
        parent.set("type", (JsonNode)type);
    }

    protected void singleSelect(ObjectNode parent, SingleSelectCapability capability) {
        this.singleSelect(parent, capability, this::mapValue, id -> id);
    }

    @Deprecated
    protected void singleSelect(ObjectNode parent, SingleSelectCapability capability, Function<MetadataElement, ObjectNode> valueMapper) {
        this.singleSelect(parent, capability, valueMapper, id -> id);
    }

    protected void singleSelect(ObjectNode parent, SingleSelectCapability capability, Function<MetadataElement, ObjectNode> valueMapper, Function<String, String> defaultMapper) {
        ObjectNode single = nodeFactory.objectNode();
        single.put("type", capability.getType().getName());
        DefaultMetadataElement defaultType = capability.getDefault();
        if (defaultType != null) {
            single.put("default", defaultMapper.apply(defaultType.getId()));
        }
        ArrayNode values = nodeFactory.arrayNode();
        values.addAll((Collection)capability.getContent().stream().map(valueMapper).collect(Collectors.toList()));
        single.set("values", (JsonNode)values);
        parent.set(capability.getId(), (JsonNode)single);
    }

    protected void text(ObjectNode parent, TextCapability capability) {
        ObjectNode text = nodeFactory.objectNode();
        text.put("type", capability.getType().getName());
        String defaultValue = capability.getContent();
        if (StringUtils.hasText((String)defaultValue)) {
            text.put("default", defaultValue);
        }
        parent.set(capability.getId(), (JsonNode)text);
    }

    protected ObjectNode mapDependencyGroup(DependencyGroup group) {
        ObjectNode result = nodeFactory.objectNode();
        result.put("name", group.getName());
        if (group instanceof Describable && ((Describable)group).getDescription() != null) {
            result.put("description", ((Describable)group).getDescription());
        }
        ArrayNode items = nodeFactory.arrayNode();
        group.getContent().forEach(it -> {
            ObjectNode dependency = this.mapDependency((Dependency)it);
            if (dependency != null) {
                items.add((JsonNode)dependency);
            }
        });
        result.set("values", (JsonNode)items);
        return result;
    }

    protected ObjectNode mapDependency(Dependency dependency) {
        if (dependency.getCompatibilityRange() == null) {
            return this.mapValue((MetadataElement)dependency);
        }
        return null;
    }

    protected ObjectNode mapType(Type type) {
        ObjectNode result = this.mapValue((MetadataElement)type);
        result.put("action", type.getAction());
        ObjectNode tags = nodeFactory.objectNode();
        type.getTags().forEach((arg_0, arg_1) -> ((ObjectNode)tags).put(arg_0, arg_1));
        result.set("tags", (JsonNode)tags);
        return result;
    }

    private ObjectNode mapVersionMetadata(MetadataElement value) {
        ObjectNode result = nodeFactory.objectNode();
        result.put("id", this.formatVersion(value.getId()));
        result.put("name", value.getName());
        return result;
    }

    protected String formatVersion(String versionId) {
        Version version = VersionParser.DEFAULT.safeParse(versionId);
        return version != null ? version.format(Version.Format.V1).toString() : versionId;
    }

    protected ObjectNode mapValue(MetadataElement value) {
        ObjectNode result = nodeFactory.objectNode();
        result.put("id", value.getId());
        result.put("name", value.getName());
        if (value instanceof Describable && ((Describable)value).getDescription() != null) {
            result.put("description", ((Describable)value).getDescription());
        }
        return result;
    }
}

