/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.common.SearchAttributes;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SearchAttributesUtil;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowExecutionMetadata {
    @Nonnull
    private final WorkflowExecutionInfo info;
    @Nonnull
    private final DataConverter dataConverter;

    WorkflowExecutionMetadata(@Nonnull WorkflowExecutionInfo info, @Nonnull DataConverter dataConverter) {
        this.info = (WorkflowExecutionInfo)Preconditions.checkNotNull((Object)info, (Object)"info");
        this.dataConverter = (DataConverter)Preconditions.checkNotNull((Object)dataConverter, (Object)"dataConverter");
    }

    @Nonnull
    public WorkflowExecution getExecution() {
        return this.info.getExecution();
    }

    @Nonnull
    public String getWorkflowType() {
        return this.info.getType().getName();
    }

    @Nonnull
    public String getTaskQueue() {
        return this.info.getTaskQueue();
    }

    @Nonnull
    public Instant getStartTime() {
        return ProtobufTimeUtils.toJavaInstant(this.info.getStartTime());
    }

    @Nonnull
    public Instant getExecutionTime() {
        return ProtobufTimeUtils.toJavaInstant(this.info.getExecutionTime());
    }

    @Nullable
    public Instant getCloseTime() {
        return this.info.hasCloseTime() ? ProtobufTimeUtils.toJavaInstant(this.info.getCloseTime()) : null;
    }

    @Nonnull
    public WorkflowExecutionStatus getStatus() {
        return this.info.getStatus();
    }

    public long getHistoryLength() {
        return this.info.getHistoryLength();
    }

    @Nullable
    public String getParentNamespace() {
        return this.info.hasParentExecution() ? this.info.getParentNamespaceId() : null;
    }

    @Nullable
    public WorkflowExecution getParentExecution() {
        return this.info.hasParentExecution() ? this.info.getParentExecution() : null;
    }

    @Deprecated
    @Nonnull
    public Map<String, List<?>> getSearchAttributes() {
        return Collections.unmodifiableMap(SearchAttributesUtil.decode(this.info.getSearchAttributes()));
    }

    @Nonnull
    public SearchAttributes getTypedSearchAttributes() {
        return SearchAttributesUtil.decodeTyped(this.info.getSearchAttributes());
    }

    @Nullable
    public <T> Object getMemo(String key, Class<T> valueClass) {
        return this.getMemo(key, valueClass, valueClass);
    }

    @Nullable
    public <T> T getMemo(String key, Class<T> valueClass, Type genericType) {
        Payload memo = (Payload)this.info.getMemo().getFieldsMap().get(key);
        if (memo == null) {
            return null;
        }
        return this.dataConverter.fromPayload(memo, valueClass, genericType);
    }

    @Nonnull
    public WorkflowExecutionInfo getWorkflowExecutionInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowExecutionMetadata that = (WorkflowExecutionMetadata)o;
        return this.info.equals((Object)that.info);
    }

    public int hashCode() {
        return Objects.hash(this.info);
    }
}

