/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import io.temporal.common.metadata.POJOWorkflowMethod;
import io.temporal.common.metadata.WorkflowMethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

public final class POJOWorkflowMethodMetadata {
    private final POJOWorkflowMethod workflowMethod;
    private final String name;
    private final Class<?> workflowInterface;

    POJOWorkflowMethodMetadata(POJOWorkflowMethod methodMetadata, Class<?> workflowInterface) {
        this.workflowMethod = Objects.requireNonNull(methodMetadata);
        if (this.workflowMethod.getType() == WorkflowMethodType.NONE) {
            throw new IllegalArgumentException("Method \"" + methodMetadata.getMethod().getName() + "\" is not annotated with @WorkflowMethod, @SignalMethod @QueryMethod, @UpdateMethod, or @UpdateValidatorMethod");
        }
        this.workflowInterface = Objects.requireNonNull(workflowInterface);
        Optional<String> nameFromAnnotation = this.workflowMethod.getNameFromAnnotation();
        this.name = this.workflowMethod.getType() == WorkflowMethodType.WORKFLOW ? nameFromAnnotation.orElse(workflowInterface.getSimpleName()) : nameFromAnnotation.orElse(methodMetadata.getMethod().getName());
    }

    public WorkflowMethodType getType() {
        return this.workflowMethod.getType();
    }

    public String getName() {
        return this.name;
    }

    public Method getWorkflowMethod() {
        return this.workflowMethod.getMethod();
    }

    public Class<?> getWorkflowInterface() {
        return this.workflowInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        POJOWorkflowMethodMetadata that = (POJOWorkflowMethodMetadata)o;
        return com.google.common.base.Objects.equal((Object)this.workflowMethod, (Object)that.workflowMethod) && com.google.common.base.Objects.equal(this.workflowInterface, that.workflowInterface);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.workflowMethod, this.workflowInterface});
    }
}

