/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.reporter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.CapableOf;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.util.Duration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MicrometerClientStatsReporter
implements StatsReporter {
    private final MeterRegistry registry;
    private final ConcurrentMap<MetricID, AtomicDouble> registeredGauges = new ConcurrentHashMap<MetricID, AtomicDouble>();

    public MicrometerClientStatsReporter(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    public Capabilities capabilities() {
        return CapableOf.REPORTING;
    }

    public void flush() {
    }

    public void close() {
        this.registry.close();
    }

    public void reportCounter(String name, Map<String, String> tags, long value) {
        this.registry.counter(name, this.getTags(tags)).increment((double)value);
    }

    public void reportGauge(String name, Map<String, String> tags, double value) {
        Preconditions.checkNotNull((Object)name, (Object)"Gauge name should be not null");
        MetricID metricID = new MetricID(name, tags);
        AtomicDouble gauge = this.registeredGauges.computeIfAbsent(metricID, _metricID -> Objects.requireNonNull((AtomicDouble)this.registry.gauge(((MetricID)_metricID).name, this.getTags(((MetricID)_metricID).tags), (Number)new AtomicDouble(value))));
        gauge.set(value);
    }

    public void reportTimer(String name, Map<String, String> tags, Duration interval) {
        Timer.builder((String)name).tags(this.getTags(tags)).publishPercentileHistogram(Boolean.valueOf(true)).register(this.registry).record(interval.getNanos(), TimeUnit.NANOSECONDS);
    }

    public void reportHistogramValueSamples(String name, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
    }

    public void reportHistogramDurationSamples(String name, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
    }

    private Iterable<Tag> getTags(Map<String, String> tags) {
        return tags != null ? (Iterable)tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static class MetricID {
        private final String name;
        private final Map<String, String> tags;

        private MetricID(String name, Map<String, String> tags) {
            this.name = name;
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricID metricID = (MetricID)o;
            return this.name.equals(metricID.name) && Objects.equals(this.tags, metricID.tags);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.tags);
        }
    }
}

