/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.WorkflowClientLongPollHelper;
import io.temporal.internal.client.WorkflowClientRequestFactory;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.common.WorkflowExecutionUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class WorkflowClientLongPollAsyncHelper {
    WorkflowClientLongPollAsyncHelper() {
    }

    static CompletableFuture<Optional<Payloads>> getWorkflowExecutionResultAsync(GenericWorkflowClient genericClient, WorkflowClientRequestFactory workflowClientHelper, @Nonnull WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit unit, DataConverter converter) {
        Deadline longPollTimeoutDeadline = Deadline.after((long)timeout, (TimeUnit)unit);
        return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(genericClient, workflowClientHelper, workflowExecution, ByteString.EMPTY, longPollTimeoutDeadline).handle((closeEvent, e) -> {
            if (e == null) {
                return WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent, converter);
            }
            throw WorkflowClientLongPollAsyncHelper.handleException(e, longPollTimeoutDeadline, workflowExecution, timeout, unit);
        });
    }

    private static CompletionException handleException(Throwable e, Deadline longPollTimeoutDeadline, @Nonnull WorkflowExecution workflowExecution, long timeout, TimeUnit unit) {
        if (e instanceof CompletionException) {
            Throwable cause = e.getCause();
            if (longPollTimeoutDeadline.isExpired() && cause instanceof StatusRuntimeException && Status.Code.DEADLINE_EXCEEDED.equals((Object)((StatusRuntimeException)cause).getStatus().getCode())) {
                return new CompletionException(WorkflowClientLongPollHelper.newTimeoutException(workflowExecution, timeout, unit));
            }
            return (CompletionException)e;
        }
        return new CompletionException(e);
    }

    private static CompletableFuture<HistoryEvent> getInstanceCloseEventAsync(GenericWorkflowClient genericClient, WorkflowClientRequestFactory workflowClientHelper, WorkflowExecution workflowExecution, ByteString pageToken, Deadline longPollTimeoutDeadline) {
        GetWorkflowExecutionHistoryRequest request = workflowClientHelper.newHistoryLongPollRequest(workflowExecution, pageToken);
        CompletableFuture<GetWorkflowExecutionHistoryResponse> response = genericClient.longPollHistoryAsync(request, longPollTimeoutDeadline);
        return response.thenComposeAsync(r -> {
            History history = r.getHistory();
            if (history.getEventsCount() == 0) {
                ByteString nextPageToken = r.getNextPageToken().isEmpty() ? pageToken : r.getNextPageToken();
                return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(genericClient, workflowClientHelper, workflowExecution, nextPageToken, longPollTimeoutDeadline);
            }
            HistoryEvent event = history.getEvents(0);
            if (!WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) {
                throw new RuntimeException("Unexpected workflow execution closing event: " + event);
            }
            if (event.getEventType() == EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW) {
                WorkflowExecution nextWorkflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId()).build();
                return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(genericClient, workflowClientHelper, nextWorkflowExecution, ByteString.EMPTY, longPollTimeoutDeadline);
            }
            return CompletableFuture.completedFuture(event);
        });
    }
}

