/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import javax.annotation.Nullable;

class WorkflowMutableState {
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionCommandAttributes continueAsNewOnCompletion;
    private boolean workflowMethodCompleted;
    private Throwable workflowTaskFailureThrowable;
    private SearchAttributes.Builder searchAttributes;

    WorkflowMutableState(WorkflowExecutionStartedEventAttributes startedAttributes) {
        if (startedAttributes.hasSearchAttributes()) {
            this.searchAttributes = startedAttributes.getSearchAttributes().toBuilder();
        }
    }

    boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested() {
        this.cancelRequested = true;
    }

    ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes parameters) {
        this.continueAsNewOnCompletion = parameters;
    }

    Throwable getWorkflowTaskFailure() {
        return this.workflowTaskFailureThrowable;
    }

    void failWorkflowTask(Throwable failure) {
        this.workflowTaskFailureThrowable = failure;
    }

    boolean isWorkflowMethodCompleted() {
        return this.workflowMethodCompleted;
    }

    void setWorkflowMethodCompleted() {
        this.workflowMethodCompleted = true;
    }

    SearchAttributes getSearchAttributes() {
        return this.searchAttributes == null || this.searchAttributes.getIndexedFieldsCount() == 0 ? null : this.searchAttributes.build();
    }

    void upsertSearchAttributes(@Nullable SearchAttributes searchAttributes) {
        if (searchAttributes == null || searchAttributes.getIndexedFieldsCount() == 0) {
            return;
        }
        if (this.searchAttributes == null) {
            this.searchAttributes = SearchAttributes.newBuilder();
        }
        this.searchAttributes.putAllIndexedFields(searchAttributes.getIndexedFieldsMap());
    }
}

