/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.DeterministicRunnerImpl;
import java.util.Optional;
import java.util.function.Supplier;

public final class RunnerLocalInternal<T> {
    private T supplierResult = null;
    private boolean supplierCalled = false;

    Optional<T> invokeSupplier(Supplier<? extends T> supplier) {
        if (!this.supplierCalled) {
            T result = supplier.get();
            this.supplierCalled = true;
            this.supplierResult = result;
            return Optional.ofNullable(result);
        }
        return Optional.ofNullable(this.supplierResult);
    }

    public T get(Supplier<? extends T> supplier) {
        Optional<Optional<Optional>> result = DeterministicRunnerImpl.currentThreadInternal().getRunner().getRunnerLocal(this);
        return result.orElseGet(() -> this.invokeSupplier(supplier)).orElse(null);
    }

    public void set(T value) {
        DeterministicRunnerImpl.currentThreadInternal().getRunner().setRunnerLocal(this, value);
    }
}

