/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.Shutdownable;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManager.class);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory("TemporalShutdownManager", null));
    private static final int CHECK_PERIOD_MS = 250;

    public CompletableFuture<Void> shutdownExecutorNow(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        executorToShutdown.shutdownNow();
        return this.limitedWait(executorToShutdown, executorName, timeout);
    }

    public CompletableFuture<Void> shutdownExecutorNowUntimed(ExecutorService executorToShutdown, String executorName) {
        executorToShutdown.shutdownNow();
        return this.untimedWait(executorToShutdown, executorName);
    }

    public CompletableFuture<Void> shutdownExecutor(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        executorToShutdown.shutdown();
        return this.limitedWait(executorToShutdown, executorName, timeout);
    }

    public CompletableFuture<Void> shutdownExecutorUntimed(ExecutorService executorToShutdown, String executorName) {
        executorToShutdown.shutdown();
        return this.untimedWait(executorToShutdown, executorName);
    }

    public CompletableFuture<Void> waitForSemaphorePermitsReleaseUntimed(Semaphore semaphore, int initialSemaphorePermits, String semaphoreName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduledExecutorService.submit(new SemaphoreReportingDelayShutdown(semaphore, initialSemaphorePermits, semaphoreName, future));
        return future;
    }

    private CompletableFuture<Void> untimedWait(ExecutorService executorToShutdown, String executorName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduledExecutorService.submit(new ExecutorReportingDelayShutdown(executorToShutdown, executorName, future));
        return future;
    }

    private CompletableFuture<Void> limitedWait(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        int attempts = (int)Math.ceil((double)timeout.toMillis() / 250.0);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduledExecutorService.submit(new ExecutorLimitedWaitShutdown(executorToShutdown, attempts, executorName, future));
        return future;
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdownNow();
    }

    public static long awaitTermination(@Nullable ExecutorService s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return ShutdownManager.runAndGetRemainingTimeoutMs(timeoutMillis, () -> {
            try {
                boolean bl = s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public static long runAndGetRemainingTimeoutMs(long initialTimeoutMs, Runnable toRun) {
        long startedNs = System.nanoTime();
        try {
            toRun.run();
        }
        catch (Throwable e) {
            log.warn("Exception during waiting for termination", e);
        }
        long remainingTimeoutMs = initialTimeoutMs - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNs);
        return remainingTimeoutMs < 0L ? 0L : remainingTimeoutMs;
    }

    public static long awaitTermination(@Nullable Shutdownable s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return ShutdownManager.runAndGetRemainingTimeoutMs(timeoutMillis, () -> s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    private class SemaphoreReportingDelayShutdown
    extends ReportingDelayShutdown {
        private final Semaphore semaphore;
        private final int initialSemaphorePermits;
        private final String semaphoreName;

        public SemaphoreReportingDelayShutdown(Semaphore semaphore, int initialSemaphorePermits, String semaphoreName, CompletableFuture<Void> promise) {
            super(promise);
            this.semaphore = semaphore;
            this.initialSemaphorePermits = initialSemaphorePermits;
            this.semaphoreName = semaphoreName;
        }

        @Override
        boolean isTerminated() {
            return this.semaphore.availablePermits() == this.initialSemaphorePermits;
        }

        @Override
        void onSlowTermination() {
            log.warn("Wait for release of slots of {} takes a long time", (Object)this.semaphoreName);
        }

        @Override
        void onSuccessfulTermination() {
        }

        @Override
        void onSlowSuccessfulTermination() {
            log.warn("All slots of {} were successfully released", (Object)this.semaphoreName);
        }
    }

    private class ExecutorReportingDelayShutdown
    extends ReportingDelayShutdown {
        private final ExecutorService executorToShutdown;
        private final String executorName;

        public ExecutorReportingDelayShutdown(ExecutorService executorToShutdown, String executorName, CompletableFuture<Void> promise) {
            super(promise);
            this.executorToShutdown = executorToShutdown;
            this.executorName = executorName;
        }

        @Override
        boolean isTerminated() {
            return this.executorToShutdown.isTerminated();
        }

        @Override
        void onSlowTermination() {
            log.warn("Graceful shutdown of {} is blocked by one of the long currently processing tasks", (Object)this.executorName);
        }

        @Override
        void onSuccessfulTermination() {
        }

        @Override
        void onSlowSuccessfulTermination() {
            log.warn("{} successfully terminated", (Object)this.executorName);
        }
    }

    private abstract class ReportingDelayShutdown
    implements Runnable {
        private static final int BLOCKED_REPORTING_THRESHOLD = 60;
        private static final int BLOCKED_REPORTING_PERIOD = 20;
        private final CompletableFuture<Void> promise;
        private int attempt;

        public ReportingDelayShutdown(CompletableFuture<Void> promise) {
            this.promise = promise;
        }

        @Override
        public void run() {
            if (this.isTerminated()) {
                if (this.attempt > 60) {
                    this.onSlowSuccessfulTermination();
                } else {
                    this.onSuccessfulTermination();
                }
                this.promise.complete(null);
                return;
            }
            ++this.attempt;
            if (this.attempt >= 60 && (double)((float)(this.attempt - 60) % 20.0f) < 0.001) {
                this.onSlowTermination();
            }
            ShutdownManager.this.scheduledExecutorService.schedule(this, 250L, TimeUnit.MILLISECONDS);
        }

        abstract boolean isTerminated();

        abstract void onSlowTermination();

        abstract void onSuccessfulTermination();

        abstract void onSlowSuccessfulTermination();
    }

    private class ExecutorLimitedWaitShutdown
    extends LimitedWaitShutdown {
        private final ExecutorService executorToShutdown;
        private final String executorName;

        public ExecutorLimitedWaitShutdown(ExecutorService executorToShutdown, int maxAttempts, String executorName, CompletableFuture<Void> promise) {
            super(maxAttempts, promise);
            this.executorToShutdown = executorToShutdown;
            this.executorName = executorName;
        }

        @Override
        boolean isTerminated() {
            return this.executorToShutdown.isTerminated();
        }

        @Override
        void onAttemptExhaustion() {
            log.warn("Wait for a graceful shutdown of {} timed out, fallback to shutdownNow()", (Object)this.executorName);
            this.executorToShutdown.shutdownNow();
        }

        @Override
        void onSuccessfulTermination() {
        }
    }

    private abstract class LimitedWaitShutdown
    implements Runnable {
        private final CompletableFuture<Void> promise;
        private final int maxAttempts;
        private int attempt;

        public LimitedWaitShutdown(int maxAttempts, CompletableFuture<Void> promise) {
            this.promise = promise;
            this.maxAttempts = maxAttempts;
        }

        @Override
        public void run() {
            if (this.isTerminated()) {
                this.onSuccessfulTermination();
                this.promise.complete(null);
                return;
            }
            ++this.attempt;
            if (this.attempt > this.maxAttempts) {
                this.onAttemptExhaustion();
                this.promise.complete(null);
                return;
            }
            ShutdownManager.this.scheduledExecutorService.schedule(this, 250L, TimeUnit.MILLISECONDS);
        }

        abstract boolean isTerminated();

        abstract void onAttemptExhaustion();

        abstract void onSuccessfulTermination();
    }
}

