/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.workflowservice.v1.UpdateWorkerBuildIdCompatibilityRequest;
import io.temporal.common.Experimental;
import javax.annotation.Nonnull;

@Experimental
public abstract class BuildIdOperation {
    private BuildIdOperation() {
    }

    abstract void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder var1);

    public static BuildIdOperation newIdInNewDefaultSet(@Nonnull String buildId) {
        return new NewIdInNewDefaultSet(buildId);
    }

    public static BuildIdOperation newCompatibleVersion(@Nonnull String buildId, @Nonnull String existingCompatibleBuildId, boolean makeSetDefault) {
        return new NewCompatibleVersion(buildId, existingCompatibleBuildId, makeSetDefault);
    }

    public static BuildIdOperation newCompatibleVersion(@Nonnull String buildId, @Nonnull String existingCompatibleBuildId) {
        return BuildIdOperation.newCompatibleVersion(buildId, existingCompatibleBuildId, false);
    }

    public static BuildIdOperation promoteSetByBuildId(@Nonnull String buildId) {
        return new PromoteSetByBuildId(buildId);
    }

    public static BuildIdOperation promoteBuildIdWithinSet(@Nonnull String buildId) {
        return new PromoteBuildIdWithinSet(buildId);
    }

    public static BuildIdOperation mergeSets(@Nonnull String primaryBuildId, @Nonnull String secondaryBuildId) {
        return new MergeSets(primaryBuildId, secondaryBuildId);
    }

    private static class MergeSets
    extends BuildIdOperation {
        private final String primaryBuildId;
        private final String secondaryBuildId;

        public MergeSets(String primaryBuildId, String secondaryBuildId) {
            this.primaryBuildId = primaryBuildId;
            this.secondaryBuildId = secondaryBuildId;
        }

        @Override
        void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder builder) {
            builder.setMergeSets(UpdateWorkerBuildIdCompatibilityRequest.MergeSets.newBuilder().setPrimarySetBuildId(this.primaryBuildId).setSecondarySetBuildId(this.secondaryBuildId).build());
        }
    }

    private static class PromoteBuildIdWithinSet
    extends BuildIdOperation {
        private final String buildId;

        public PromoteBuildIdWithinSet(String buildId) {
            this.buildId = buildId;
        }

        @Override
        void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder builder) {
            builder.setPromoteBuildIdWithinSet(this.buildId);
        }
    }

    private static class PromoteSetByBuildId
    extends BuildIdOperation {
        private final String buildId;

        public PromoteSetByBuildId(String buildId) {
            this.buildId = buildId;
        }

        @Override
        void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder builder) {
            builder.setPromoteSetByBuildId(this.buildId);
        }
    }

    private static class NewCompatibleVersion
    extends BuildIdOperation {
        private final String buildId;
        private final String existingCompatibleBuildId;
        private final boolean makeSetDefault;

        public NewCompatibleVersion(String buildId, String existingCompatibleBuildId, boolean makeSetDefault) {
            this.buildId = buildId;
            this.existingCompatibleBuildId = existingCompatibleBuildId;
            this.makeSetDefault = makeSetDefault;
        }

        @Override
        void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder builder) {
            builder.setAddNewCompatibleBuildId(UpdateWorkerBuildIdCompatibilityRequest.AddNewCompatibleVersion.newBuilder().setNewBuildId(this.buildId).setExistingCompatibleBuildId(this.existingCompatibleBuildId).setMakeSetDefault(this.makeSetDefault).build());
        }
    }

    private static class NewIdInNewDefaultSet
    extends BuildIdOperation {
        private final String buildId;

        public NewIdInNewDefaultSet(String buildId) {
            this.buildId = buildId;
        }

        @Override
        void augmentBuilder(UpdateWorkerBuildIdCompatibilityRequest.Builder builder) {
            builder.setAddNewBuildIdInNewDefaultSet(this.buildId);
        }
    }
}

