/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.BatchRequest;
import io.temporal.client.WorkflowInvocationHandler;
import io.temporal.client.WorkflowStub;
import io.temporal.workflow.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class SignalWithStartBatchRequest
implements BatchRequest {
    private final List<Functions.Proc> requests = new ArrayList<Functions.Proc>();
    private WorkflowStub stub;
    private String signalName;
    private Object[] signalArgs;
    private Object[] startArgs;
    private final AtomicBoolean invoked = new AtomicBoolean();

    SignalWithStartBatchRequest() {
    }

    WorkflowExecution invoke() {
        if (!this.invoked.compareAndSet(false, true)) {
            throw new IllegalStateException("A batch instance can be used only for a single signalWithStart call");
        }
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.SIGNAL_WITH_START, this);
        try {
            for (Functions.Proc request : this.requests) {
                request.apply();
            }
            WorkflowExecution workflowExecution = this.signalWithStart();
            return workflowExecution;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    private WorkflowExecution signalWithStart() {
        return this.stub.signalWithStart(this.signalName, this.signalArgs, this.startArgs);
    }

    void signal(WorkflowStub stub, String signalName, Object[] args) {
        this.setStub(stub);
        this.signalName = signalName;
        this.signalArgs = args;
    }

    void start(WorkflowStub stub, Object[] args) {
        this.setStub(stub);
        this.startArgs = args;
    }

    private void setStub(WorkflowStub stub) {
        if (this.stub != null && stub != this.stub) {
            throw new IllegalArgumentException("SignalWithStart Batch invoked on different workflow stubs");
        }
        this.stub = stub;
    }

    @Override
    public void add(Functions.Proc request) {
        this.requests.add(request);
    }

    @Override
    public <A1> void add(Functions.Proc1<A1> request, A1 arg1) {
        this.add(() -> request.apply(arg1));
    }

    @Override
    public <A1, A2> void add(Functions.Proc2<A1, A2> request, A1 arg1, A2 arg2) {
        this.add(() -> request.apply(arg1, arg2));
    }

    @Override
    public <A1, A2, A3> void add(Functions.Proc3<A1, A2, A3> request, A1 arg1, A2 arg2, A3 arg3) {
        this.add(() -> request.apply(arg1, arg2, arg3));
    }

    @Override
    public <A1, A2, A3, A4> void add(Functions.Proc4<A1, A2, A3, A4> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4));
    }

    @Override
    public <A1, A2, A3, A4, A5> void add(Functions.Proc5<A1, A2, A3, A4, A5> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4, arg5));
    }

    @Override
    public <A1, A2, A3, A4, A5, A6> void add(Functions.Proc6<A1, A2, A3, A4, A5, A6> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    @Override
    public void add(Functions.Func<?> request) {
        this.add(() -> request.apply());
    }

    @Override
    public <A1> void add(Functions.Func1<A1, ?> request, A1 arg1) {
        this.add(() -> request.apply(arg1));
    }

    @Override
    public <A1, A2> void add(Functions.Func2<A1, A2, ?> request, A1 arg1, A2 arg2) {
        this.add(() -> request.apply(arg1, arg2));
    }

    @Override
    public <A1, A2, A3> void add(Functions.Func3<A1, A2, A3, ?> request, A1 arg1, A2 arg2, A3 arg3) {
        this.add(() -> request.apply(arg1, arg2, arg3));
    }

    @Override
    public <A1, A2, A3, A4> void add(Functions.Func4<A1, A2, A3, A4, ?> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4));
    }

    @Override
    public <A1, A2, A3, A4, A5> void add(Functions.Func5<A1, A2, A3, A4, A5, ?> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4, arg5));
    }

    @Override
    public <A1, A2, A3, A4, A5, A6> void add(Functions.Func6<A1, A2, A3, A4, A5, A6, ?> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        this.add(() -> request.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }
}

