/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.Values;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

public final class EncodedValues
implements Values {
    private Optional<Payloads> payloads;
    private DataConverter converter;
    private final Object[] values;

    public EncodedValues(Optional<Payloads> payloads, DataConverter converter) {
        this.payloads = Objects.requireNonNull(payloads);
        this.converter = converter;
        this.values = null;
    }

    public EncodedValues(Object ... values) {
        this.values = values;
        this.payloads = null;
    }

    public Optional<Payloads> toPayloads() {
        if (this.payloads == null) {
            if (this.values == null || this.values.length == 0) {
                this.payloads = Optional.empty();
            } else {
                if (this.converter == null) {
                    throw new IllegalStateException("converter not set");
                }
                this.payloads = this.converter.toPayloads(this.values);
            }
        }
        return this.payloads;
    }

    public void setDataConverter(DataConverter converter) {
        this.converter = Objects.requireNonNull(converter);
    }

    @Override
    public int getSize() {
        if (this.values != null) {
            return this.values.length;
        }
        if (this.payloads.isPresent()) {
            return this.payloads.get().getPayloadsCount();
        }
        return 0;
    }

    @Override
    public <T> T get(int index, Class<T> parameterType) throws DataConverterException {
        return this.get(index, parameterType, parameterType);
    }

    @Override
    public <T> T get(int index, Class<T> parameterType, Type genericParameterType) throws DataConverterException {
        if (this.values != null) {
            Object result = this.values[index];
            return (T)result;
        }
        if (this.converter == null) {
            throw new IllegalStateException("converter not set");
        }
        return this.converter.fromPayloads(index, this.payloads, parameterType, genericParameterType);
    }
}

