/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.util.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProtobufTimeUtils {
    static final long MAX_SECONDS = 315576000000L;
    static final long MIN_SECONDS = -315576000000L;
    static final int MAX_NANOS = 999999999;
    static final int MIN_NANOS = -999999999;
    static final int MILLIS_PER_NANO = 1000000;

    @Nonnull
    public static java.time.Duration toJavaDuration(@Nullable com.google.protobuf.Duration d) {
        if (Objects.isNull(d)) {
            return java.time.Duration.ZERO;
        }
        long rawSeconds = d.getSeconds();
        int rawNanos = d.getNanos();
        long saturatedSeconds = Math.min(315576000000L, Math.max(-315576000000L, rawSeconds));
        int saturatedNanos = Math.min(999999999, Math.max(-999999999, rawNanos));
        int roundedNanos = saturatedNanos / 1000000 * 1000000;
        return java.time.Duration.ofSeconds(saturatedSeconds, roundedNanos);
    }

    @Nonnull
    public static com.google.protobuf.Duration toProtoDuration(@Nullable java.time.Duration d) {
        if (Objects.isNull(d)) {
            return Durations.ZERO;
        }
        return Durations.fromMillis((long)d.toMillis());
    }

    public static Timestamp getCurrentProtoTime() {
        return Timestamps.fromMillis((long)System.currentTimeMillis());
    }

    public static Duration toM3Duration(Timestamp to, Timestamp from) {
        return Duration.ofMillis((double)(Timestamps.toMillis((Timestamp)to) - Timestamps.toMillis((Timestamp)from)));
    }

    public static Duration toM3DurationSinceNow(Timestamp t) {
        return Duration.ofMillis((double)(System.currentTimeMillis() - Timestamps.toMillis((Timestamp)t)));
    }

    @Nullable
    public static Instant toJavaInstant(@Nullable Timestamp t) {
        if (t == null) {
            return null;
        }
        return Instant.ofEpochSecond(t.getSeconds(), t.getNanos());
    }

    @Nullable
    public static Timestamp toProtoTimestamp(@Nullable Instant t) {
        if (t == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(t.getEpochSecond()).setNanos(t.getNano()).build();
    }
}

