/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.CancelExternalWorkflowException;
import io.temporal.workflow.Functions;

final class CancelExternalStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, CancelExternalStateMachine> {
    private final RequestCancelExternalWorkflowExecutionCommandAttributes requestCancelAttributes;
    private final Functions.Proc2<Void, RuntimeException> completionCallback;
    public static final StateMachineDefinition<State, ExplicitEvent, CancelExternalStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("CancelExternal", State.CREATED, State.CANCEL_REQUESTED, State.REQUEST_CANCEL_FAILED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.REQUEST_CANCEL_EXTERNAL_COMMAND_CREATED, CancelExternalStateMachine::createCancelExternalCommand).add(State.REQUEST_CANCEL_EXTERNAL_COMMAND_CREATED, CommandType.COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION, State.REQUEST_CANCEL_EXTERNAL_COMMAND_CREATED).add(State.REQUEST_CANCEL_EXTERNAL_COMMAND_CREATED, EventType.EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED, State.REQUEST_CANCEL_EXTERNAL_COMMAND_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.REQUEST_CANCEL_EXTERNAL_COMMAND_RECORDED, EventType.EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED, State.CANCEL_REQUESTED, CancelExternalStateMachine::notifyCompleted).add(State.REQUEST_CANCEL_EXTERNAL_COMMAND_RECORDED, EventType.EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED, State.REQUEST_CANCEL_FAILED, CancelExternalStateMachine::notifyFailed);

    public static void newInstance(RequestCancelExternalWorkflowExecutionCommandAttributes attributes, Functions.Proc2<Void, RuntimeException> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        new CancelExternalStateMachine(attributes, completionCallback, commandSink, stateMachineSink);
    }

    private CancelExternalStateMachine(RequestCancelExternalWorkflowExecutionCommandAttributes requestCancelAttributes, Functions.Proc2<Void, RuntimeException> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.requestCancelAttributes = requestCancelAttributes;
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    private void createCancelExternalCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION).setRequestCancelExternalWorkflowExecutionCommandAttributes(this.requestCancelAttributes).build());
    }

    private void notifyCompleted() {
        this.completionCallback.apply(null, null);
    }

    private void notifyFailed() {
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(this.requestCancelAttributes.getWorkflowId()).setRunId(this.requestCancelAttributes.getRunId()).build();
        this.completionCallback.apply(null, new CancelExternalWorkflowException("Workflow not found: " + execution, execution, "", null));
    }

    static enum State {
        CREATED,
        REQUEST_CANCEL_EXTERNAL_COMMAND_CREATED,
        REQUEST_CANCEL_EXTERNAL_COMMAND_RECORDED,
        CANCEL_REQUESTED,
        REQUEST_CANCEL_FAILED;

    }

    static enum ExplicitEvent {
        SCHEDULE;

    }
}

