/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.DeterministicRunnerImpl;
import java.util.Optional;
import java.util.function.Supplier;

public final class WorkflowThreadLocalInternal<T> {
    private final boolean useCaching;

    public WorkflowThreadLocalInternal() {
        this(false);
    }

    public WorkflowThreadLocalInternal(boolean useCaching) {
        this.useCaching = useCaching;
    }

    public T get(Supplier<? extends T> supplier) {
        Optional<Optional<Optional>> result = DeterministicRunnerImpl.currentThreadInternal().getThreadLocal(this);
        T out = result.orElseGet(() -> Optional.ofNullable(supplier.get())).orElse(null);
        if (!result.isPresent() && this.useCaching) {
            this.set(out);
        }
        return out;
    }

    public void set(T value) {
        DeterministicRunnerImpl.currentThreadInternal().setThreadLocal(this, value);
    }
}

