/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.DoubleValue;
import com.google.protobuf.Timestamp;
import com.uber.m3.tally.Scope;
import io.grpc.Context;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.taskqueue.v1.TaskQueueMetadata;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.GrpcUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.AsyncPoller;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerVersioningOptions;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.PollerTypeMetricsTag;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncActivityPollTask
implements AsyncPoller.PollTaskAsync<ActivityTask> {
    private static final Logger log = LoggerFactory.getLogger(AsyncActivityPollTask.class);
    private final TrackingSlotSupplier<?> slotSupplier;
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final PollActivityTaskQueueRequest pollRequest;
    private final AtomicInteger pollGauge = new AtomicInteger();
    private final Context.CancellableContext grpcContext = Context.ROOT.withCancellation();

    public AsyncActivityPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nonnull WorkerVersioningOptions versioningOptions, double activitiesPerSecond, @Nonnull TrackingSlotSupplier<ActivitySlotInfo> slotSupplier, @Nonnull Scope metricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.service = service;
        this.slotSupplier = slotSupplier;
        this.metricsScope = metricsScope;
        PollActivityTaskQueueRequest.Builder pollRequest = PollActivityTaskQueueRequest.newBuilder().setNamespace(namespace).setIdentity(identity).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        if (activitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(activitiesPerSecond).build()).build());
        }
        if (versioningOptions.getWorkerDeploymentOptions() != null) {
            pollRequest.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(versioningOptions.getWorkerDeploymentOptions()));
        } else if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequest.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(versioningOptions.getBuildId()).setUseVersioning(versioningOptions.isUsingVersioning()).build());
        }
        this.pollRequest = pollRequest.build();
    }

    @Override
    public CompletableFuture<ActivityTask> poll(SlotPermit permit) {
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + this.pollRequest);
        }
        MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.ACTIVITY_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.incrementAndGet());
        CompletableFuture response = null;
        try {
            response = (CompletableFuture)this.grpcContext.call(() -> GrpcUtils.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollActivityTaskQueue(this.pollRequest)));
        }
        catch (Exception e2) {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.ACTIVITY_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet());
            throw new RuntimeException(e2);
        }
        return ((CompletableFuture)response.thenApply(r -> {
            if (r == null || r.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_activity_poll_no_task").inc(1L);
                return null;
            }
            Timestamp startedTime = ProtobufTimeUtils.getCurrentProtoTime();
            this.metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(startedTime, r.getScheduledTime()));
            return new ActivityTask((PollActivityTaskQueueResponseOrBuilder)r, permit, () -> this.slotSupplier.releaseSlot(SlotReleaseReason.taskComplete(), permit));
        })).whenComplete((r, e) -> MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.ACTIVITY_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet()));
    }

    @Override
    public void cancel(Throwable cause) {
        this.grpcContext.cancel(cause);
    }

    @Override
    public String getLabel() {
        return "AsyncActivityPollTask";
    }

    public String toString() {
        return "AsyncActivityPollTask{}";
    }
}

